/*
 * Decompiled with CFR 0.152.
 */
package xyz.nucleoid.fantasy;

import java.io.File;
import java.io.IOException;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerWorldEvents;
import net.minecraft.class_1937;
import net.minecraft.class_2370;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_32;
import net.minecraft.class_3218;
import net.minecraft.class_3536;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_5455;
import net.minecraft.class_7924;
import net.minecraft.class_9248;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.io.FileUtils;
import xyz.nucleoid.fantasy.Fantasy;
import xyz.nucleoid.fantasy.FantasyDimensionOptions;
import xyz.nucleoid.fantasy.RemoveFromRegistry;
import xyz.nucleoid.fantasy.RuntimeWorld;
import xyz.nucleoid.fantasy.RuntimeWorldConfig;
import xyz.nucleoid.fantasy.mixin.MinecraftServerAccess;

final class RuntimeWorldManager {
    private final MinecraftServer server;
    private final MinecraftServerAccess serverAccess;

    RuntimeWorldManager(MinecraftServer server) {
        this.server = server;
        this.serverAccess = (MinecraftServerAccess)server;
    }

    RuntimeWorld add(class_5321<class_1937> worldKey, RuntimeWorldConfig config, RuntimeWorld.Style style) {
        class_5363 options = config.createDimensionOptions(this.server);
        if (style == RuntimeWorld.Style.TEMPORARY) {
            ((FantasyDimensionOptions)options).fantasy$setSave(false);
        }
        ((FantasyDimensionOptions)options).fantasy$setSaveProperties(false);
        class_2370<class_5363> dimensionsRegistry = RuntimeWorldManager.getDimensionsRegistry(this.server);
        boolean isFrozen = ((RemoveFromRegistry)dimensionsRegistry).fantasy$isFrozen();
        ((RemoveFromRegistry)dimensionsRegistry).fantasy$setFrozen(false);
        class_5321 key = class_5321.method_29179((class_5321)class_7924.field_41224, (class_2960)worldKey.method_29177());
        if (!dimensionsRegistry.method_35842(key)) {
            dimensionsRegistry.method_10272(key, (Object)options, class_9248.field_49136);
        }
        ((RemoveFromRegistry)dimensionsRegistry).fantasy$setFrozen(isFrozen);
        RuntimeWorld world = config.getWorldConstructor().createWorld(this.server, worldKey, config, style);
        this.serverAccess.getLevels().put((class_5321<class_1937>)world.method_27983(), world);
        ((ServerWorldEvents.Load)ServerWorldEvents.LOAD.invoker()).onWorldLoad(this.server, (class_3218)world);
        world.method_18765(() -> true);
        return world;
    }

    void delete(class_3218 world) {
        class_5321 dimensionKey = world.method_27983();
        if (this.serverAccess.getLevels().remove(dimensionKey, world)) {
            ((ServerWorldEvents.Unload)ServerWorldEvents.UNLOAD.invoker()).onWorldUnload(this.server, world);
            class_2370<class_5363> dimensionsRegistry = RuntimeWorldManager.getDimensionsRegistry(this.server);
            RemoveFromRegistry.remove(dimensionsRegistry, dimensionKey.method_29177());
            class_32.class_5143 session = this.serverAccess.getStorageSource();
            File worldDirectory = session.method_27424(dimensionKey).toFile();
            if (worldDirectory.exists()) {
                try {
                    FileUtils.deleteDirectory((File)worldDirectory);
                }
                catch (IOException e) {
                    Fantasy.LOGGER.warn("Failed to delete world directory", (Throwable)e);
                    try {
                        FileUtils.forceDeleteOnExit((File)worldDirectory);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    void unload(class_3218 world) {
        class_5321 dimensionKey = world.method_27983();
        if (this.serverAccess.getLevels().remove(dimensionKey, world)) {
            world.method_14176(new class_3536(this){

                public void method_15412(class_2561 title) {
                }

                public void method_15413(class_2561 title) {
                }

                public void method_15414(class_2561 task) {
                }

                public void method_15410(int percentage) {
                }

                public void method_15411() {
                }
            }, true, false);
            ((ServerWorldEvents.Unload)ServerWorldEvents.UNLOAD.invoker()).onWorldUnload(this.server, world);
            class_2370<class_5363> dimensionsRegistry = RuntimeWorldManager.getDimensionsRegistry(this.server);
            RemoveFromRegistry.remove(dimensionsRegistry, dimensionKey.method_29177());
        }
    }

    private static class_2370<class_5363> getDimensionsRegistry(MinecraftServer server) {
        class_5455.class_6890 registryManager = server.method_46221().method_45926();
        return (class_2370)registryManager.method_30530(class_7924.field_41224);
    }
}

