/*
 * Decompiled with CFR 0.152.
 */
package xyz.nucleoid.map_templates;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.Iterator;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2791;
import net.minecraft.class_4076;
import net.minecraft.class_5539;
import net.minecraft.class_5819;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record BlockBounds(class_2338 min, class_2338 max) implements Iterable<class_2338>
{
    public static final Codec<BlockBounds> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2338.field_25064.fieldOf("min").forGetter(BlockBounds::min), (App)class_2338.field_25064.fieldOf("max").forGetter(BlockBounds::max)).apply((Applicative)instance, BlockBounds::new));
    public static final class_9139<ByteBuf, BlockBounds> PACKET_CODEC = class_9139.method_56435((class_9139)class_2338.field_48404, BlockBounds::min, (class_9139)class_2338.field_48404, BlockBounds::max, BlockBounds::of);

    public BlockBounds {
        if (min.method_10263() > max.method_10263() || min.method_10264() > max.method_10264() || min.method_10260() > max.method_10260()) {
            String message = String.format("Minimum position (%d, %d, %d) of bounds must be smaller than maximum position (%d, %d, %d)", min.method_10263(), min.method_10264(), min.method_10260(), max.method_10263(), max.method_10264(), max.method_10260());
            throw new IllegalArgumentException(message);
        }
    }

    public static BlockBounds of(class_2338 a, class_2338 b) {
        return new BlockBounds(class_2338.method_58249((class_2338)a, (class_2338)b), class_2338.method_58250((class_2338)a, (class_2338)b));
    }

    public static BlockBounds of(int x0, int y0, int z0, int x1, int y1, int z1) {
        return BlockBounds.of(new class_2338(x0, y0, z0), new class_2338(x1, y1, z1));
    }

    public static BlockBounds ofBlock(class_2338 pos) {
        return new BlockBounds(pos, pos);
    }

    public static BlockBounds ofChunk(class_2791 chunk) {
        return BlockBounds.ofChunk(chunk.method_12004(), (class_5539)chunk);
    }

    public static BlockBounds ofChunk(class_1923 chunk, class_5539 world) {
        return new BlockBounds(new class_2338(chunk.method_8326(), world.method_31607(), chunk.method_8328()), new class_2338(chunk.method_8327(), world.method_31600(), chunk.method_8329()));
    }

    public BlockBounds offset(class_2338 pos) {
        return new BlockBounds(this.min.method_10081((class_2382)pos), this.max.method_10081((class_2382)pos));
    }

    public BlockBounds offset(int x, int y, int z) {
        return new BlockBounds(this.min.method_10069(x, y, z), this.max.method_10069(x, y, z));
    }

    public boolean contains(class_2338 pos) {
        return this.contains(pos.method_10263(), pos.method_10264(), pos.method_10260());
    }

    public boolean contains(int x, int y, int z) {
        return x >= this.min.method_10263() && y >= this.min.method_10264() && z >= this.min.method_10260() && x <= this.max.method_10263() && y <= this.max.method_10264() && z <= this.max.method_10260();
    }

    public boolean contains(int x, int z) {
        return x >= this.min.method_10263() && z >= this.min.method_10260() && x <= this.max.method_10263() && z <= this.max.method_10260();
    }

    public boolean intersects(BlockBounds bounds) {
        return this.max.method_10263() >= bounds.min.method_10263() && this.min.method_10263() <= bounds.max.method_10263() && this.max.method_10264() >= bounds.min.method_10264() && this.min.method_10264() <= bounds.max.method_10264() && this.max.method_10260() >= bounds.min.method_10260() && this.min.method_10260() <= bounds.max.method_10260();
    }

    @Nullable
    public BlockBounds intersection(BlockBounds bounds) {
        if (!this.intersects(bounds)) {
            return null;
        }
        class_2338 min = class_2338.method_58250((class_2338)this.min(), (class_2338)bounds.min());
        class_2338 max = class_2338.method_58249((class_2338)this.max(), (class_2338)bounds.max());
        return new BlockBounds(min, max);
    }

    @NotNull
    public BlockBounds union(BlockBounds bounds) {
        class_2338 min = class_2338.method_58249((class_2338)this.min(), (class_2338)bounds.min());
        class_2338 max = class_2338.method_58250((class_2338)this.max(), (class_2338)bounds.max());
        return new BlockBounds(min, max);
    }

    public class_2338 size() {
        return this.max.method_10059((class_2382)this.min);
    }

    public class_243 center() {
        return new class_243((double)(this.min.method_10263() + this.max.method_10263() + 1) / 2.0, (double)(this.min.method_10264() + this.max.method_10264() + 1) / 2.0, (double)(this.min.method_10260() + this.max.method_10260() + 1) / 2.0);
    }

    public class_243 centerBottom() {
        return new class_243((double)(this.min.method_10263() + this.max.method_10263() + 1) / 2.0, (double)this.min.method_10264(), (double)(this.min.method_10260() + this.max.method_10260() + 1) / 2.0);
    }

    public class_243 centerTop() {
        return new class_243((double)(this.min.method_10263() + this.max.method_10263() + 1) / 2.0, (double)this.max.method_10264() + 1.0, (double)(this.min.method_10260() + this.max.method_10260() + 1) / 2.0);
    }

    @Override
    public Iterator<class_2338> iterator() {
        return class_2338.method_10097((class_2338)this.min, (class_2338)this.max).iterator();
    }

    public LongSet asChunks() {
        int minChunkX = this.min.method_10263() >> 4;
        int minChunkZ = this.min.method_10260() >> 4;
        int maxChunkX = this.max.method_10263() >> 4;
        int maxChunkZ = this.max.method_10260() >> 4;
        LongOpenHashSet chunks = new LongOpenHashSet((maxChunkX - minChunkX + 1) * (maxChunkZ - minChunkZ + 1));
        for (int chunkZ = minChunkZ; chunkZ <= maxChunkZ; ++chunkZ) {
            for (int chunkX = minChunkX; chunkX <= maxChunkX; ++chunkX) {
                chunks.add(class_1923.method_8331((int)chunkX, (int)chunkZ));
            }
        }
        return chunks;
    }

    public LongSet asChunkSections() {
        int minChunkX = this.min.method_10263() >> 4;
        int minChunkY = this.min.method_10264() >> 4;
        int minChunkZ = this.min.method_10260() >> 4;
        int maxChunkX = this.max.method_10263() >> 4;
        int maxChunkY = this.max.method_10264() >> 4;
        int maxChunkZ = this.max.method_10260() >> 4;
        LongOpenHashSet chunks = new LongOpenHashSet((maxChunkX - minChunkX + 1) * (maxChunkY - minChunkY + 1) * (maxChunkZ - minChunkZ + 1));
        for (int chunkZ = minChunkZ; chunkZ <= maxChunkZ; ++chunkZ) {
            for (int chunkY = minChunkY; chunkY <= maxChunkY; ++chunkY) {
                for (int chunkX = minChunkX; chunkX <= maxChunkX; ++chunkX) {
                    chunks.add(class_4076.method_18685((int)chunkX, (int)chunkY, (int)chunkZ));
                }
            }
        }
        return chunks;
    }

    public class_2338 sampleBlock(class_5819 random) {
        return new class_2338(random.method_39332(this.min.method_10263(), this.max.method_10263()), random.method_39332(this.min.method_10264(), this.max.method_10264()), random.method_39332(this.min.method_10260(), this.max.method_10260()));
    }

    public class_238 asBox() {
        return new class_238((double)this.min.method_10263(), (double)this.min.method_10264(), (double)this.min.method_10260(), (double)this.max.method_10263() + 1.0, (double)this.max.method_10264() + 1.0, (double)this.max.method_10260() + 1.0);
    }

    public class_2487 serialize(class_2487 root) {
        root.method_10539("min", new int[]{this.min.method_10263(), this.min.method_10264(), this.min.method_10260()});
        root.method_10539("max", new int[]{this.max.method_10263(), this.max.method_10264(), this.max.method_10260()});
        return root;
    }

    public static BlockBounds deserialize(class_2487 root) {
        int[] minArray = (int[])root.method_10561("min").orElseThrow();
        int[] maxArray = (int[])root.method_10561("max").orElseThrow();
        return new BlockBounds(new class_2338(minArray[0], minArray[1], minArray[2]), new class_2338(maxArray[0], maxArray[1], maxArray[2]));
    }

    @Deprecated
    public static class_2338 min(class_2338 a, class_2338 b) {
        return class_2338.method_58249((class_2338)a, (class_2338)b);
    }

    @Deprecated
    public static class_2338 max(class_2338 a, class_2338 b) {
        return class_2338.method_58250((class_2338)a, (class_2338)b);
    }
}

