/*
 * Decompiled with CFR 0.152.
 */
package xyz.nucleoid.map_templates;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2359;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2841;
import net.minecraft.class_4076;
import net.minecraft.class_6563;
import net.minecraft.class_7225;
import xyz.nucleoid.map_templates.MapEntity;

public final class MapChunk {
    private static final class_2680 DEFAULT_BLOCK = class_2246.field_10124.method_9564();
    private static final class_6563<class_2680> PALETTE_PROVIDER = class_6563.method_74162((class_2359)class_2248.field_10651);
    private static final Codec<class_2841<class_2680>> BLOCK_CODEC = class_2841.method_44343((Codec)class_2680.field_24734, PALETTE_PROVIDER, (Object)DEFAULT_BLOCK);
    private final class_4076 pos;
    private class_2841<class_2680> container = new class_2841((Object)DEFAULT_BLOCK, PALETTE_PROVIDER);
    private final List<MapEntity> entities = new ArrayList<MapEntity>();

    MapChunk(class_4076 pos) {
        this.pos = pos;
    }

    public void set(int x, int y, int z, class_2680 state) {
        this.container.method_35321(x, y, z, (Object)state);
    }

    public class_2680 get(int x, int y, int z) {
        return (class_2680)this.container.method_12321(x, y, z);
    }

    public void addEntity(class_1297 entity, class_243 position) {
        MapEntity mapEntity = MapEntity.fromEntity(entity, position);
        if (mapEntity != null) {
            this.entities.add(mapEntity);
        }
    }

    public void addEntity(MapEntity entity) {
        this.entities.add(entity);
    }

    public class_4076 getPos() {
        return this.pos;
    }

    public List<MapEntity> getEntities() {
        return this.entities;
    }

    public void serialize(class_2487 nbt, class_7225.class_7874 registryLookup) {
        nbt.method_10566("block_states", (class_2520)BLOCK_CODEC.encodeStart((DynamicOps)class_2509.field_11560, this.container).getOrThrow());
        if (!this.entities.isEmpty()) {
            class_2499 entitiesNbt = new class_2499();
            for (MapEntity entity : this.entities) {
                entitiesNbt.add((Object)entity.nbt());
            }
            nbt.method_10566("entities", (class_2520)entitiesNbt);
        }
    }

    public static MapChunk deserialize(class_4076 pos, class_2487 nbt, class_7225.class_7874 registryLookup) {
        MapChunk chunk = new MapChunk(pos);
        Optional container = nbt.method_67491("block_states", BLOCK_CODEC);
        if (container.isPresent()) {
            chunk.container = (class_2841)container.get();
        }
        class_2499 entitiesNbt = nbt.method_68569("entities");
        for (class_2520 item : entitiesNbt) {
            if (!(item instanceof class_2487)) continue;
            class_2487 entityNbt = (class_2487)item;
            chunk.entities.add(MapEntity.fromNbt(pos, entityNbt));
        }
        return chunk;
    }
}

