/*
 * Decompiled with CFR 0.152.
 */
package xyz.nucleoid.map_templates;

import java.util.function.Consumer;
import net.minecraft.class_11362;
import net.minecraft.class_11372;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2489;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_4076;
import net.minecraft.class_7225;
import net.minecraft.class_8942;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.nucleoid.map_templates.MapTransform;

public record MapEntity(class_243 position, class_2487 nbt) {
    private static final Logger LOGGER = LoggerFactory.getLogger(MapEntity.class);

    public class_2487 createEntityNbt(class_2338 origin) {
        class_2487 nbt = this.nbt.method_10553();
        class_243 chunkLocalPos = (class_243)this.nbt.method_67491("Pos", class_243.field_38277).orElseThrow();
        class_243 worldPosition = this.position.method_1031((double)origin.method_10263(), (double)origin.method_10264(), (double)origin.method_10260());
        nbt.method_10566("Pos", (class_2520)MapEntity.posToList(worldPosition));
        nbt.method_67491("block_pos", class_2338.field_25064).ifPresent(pos -> {
            double x = (double)pos.method_10263() - worldPosition.field_1352 + chunkLocalPos.field_1352;
            double y = (double)pos.method_10264() - worldPosition.field_1351 + chunkLocalPos.field_1351;
            double z = (double)pos.method_10260() - worldPosition.field_1350 + chunkLocalPos.field_1350;
            nbt.method_67494("block_pos", class_2338.field_25064, (Object)class_2338.method_49637((double)x, (double)y, (double)z));
        });
        return nbt;
    }

    public void createEntities(class_1937 world, class_2338 origin, Consumer<class_1297> consumer) {
        class_2487 nbt = this.createEntityNbt(origin);
        class_1299.method_71371((class_2487)nbt, (class_1937)world, (class_3730)class_3730.field_16474, entity -> {
            consumer.accept((class_1297)entity);
            return entity;
        });
    }

    @Nullable
    public static MapEntity fromEntity(class_1297 entity, class_243 position) {
        try (class_8942.class_11340 errorReporter = new class_8942.class_11340(entity.method_71370(), LOGGER);){
            class_11362 view = class_11362.method_71459((class_8942)errorReporter, (class_7225.class_7874)entity.method_56673());
            if (!entity.method_5662((class_11372)view)) {
                MapEntity mapEntity = null;
                return mapEntity;
            }
            view.method_71478("UUID");
            class_2338 minChunkPos = MapEntity.getMinChunkPosFor(position);
            view.method_71468("Pos", class_243.field_38277, (Object)position.method_1023((double)minChunkPos.method_10263(), (double)minChunkPos.method_10264(), (double)minChunkPos.method_10260()));
            view.method_71475().method_67491("block_pos", class_2338.field_25064).ifPresent(pos -> {
                class_2338 localPos = pos.method_10059((class_2382)entity.method_24515()).method_10069(class_3532.method_15357((double)position.method_10216()), class_3532.method_15357((double)position.method_10214()), class_3532.method_15357((double)position.method_10215())).method_10059((class_2382)minChunkPos);
                view.method_71468("block_pos", class_2338.field_25064, (Object)localPos);
            });
            MapEntity mapEntity = new MapEntity(position, view.method_71475());
            return mapEntity;
        }
    }

    public static MapEntity fromNbt(class_4076 sectionPos, class_2487 nbt) {
        class_243 localPos = (class_243)nbt.method_67491("Pos", class_243.field_38277).orElseThrow();
        class_243 globalPos = localPos.method_1031((double)sectionPos.method_19527(), (double)sectionPos.method_19528(), (double)sectionPos.method_19529());
        return new MapEntity(globalPos, nbt);
    }

    MapEntity transformed(MapTransform transform) {
        class_243 resultPosition = transform.transformedPoint(this.position);
        class_2487 resultNbt = this.nbt.method_10553();
        class_2338 minChunkPos = MapEntity.getMinChunkPosFor(this.position);
        class_2338 minResultChunkPos = MapEntity.getMinChunkPosFor(resultPosition);
        resultNbt.method_10566("Pos", (class_2520)MapEntity.posToList(resultPosition.method_1023((double)minResultChunkPos.method_10263(), (double)minResultChunkPos.method_10264(), (double)minResultChunkPos.method_10260())));
        resultNbt.method_67491("block_pos", class_2338.field_25064).ifPresent(pos -> {
            class_2338 attachedPos = pos.method_10081((class_2382)minChunkPos);
            class_2338 localAttachedPos = transform.transformedPoint(attachedPos).method_10059((class_2382)minResultChunkPos);
            resultNbt.method_67494("block_pos", class_2338.field_25064, (Object)localAttachedPos);
        });
        return new MapEntity(resultPosition, resultNbt);
    }

    private static class_2338 getMinChunkPosFor(class_243 position) {
        return new class_2338(class_3532.method_15357((double)position.method_10216()) & 0xFFFFFFF0, class_3532.method_15357((double)position.method_10214()) & 0xFFFFFFF0, class_3532.method_15357((double)position.method_10215()) & 0xFFFFFFF0);
    }

    private static class_2499 posToList(class_243 pos) {
        class_2499 list = new class_2499();
        list.add((Object)class_2489.method_23241((double)pos.field_1352));
        list.add((Object)class_2489.method_23241((double)pos.field_1351));
        list.add((Object)class_2489.method_23241((double)pos.field_1350));
        return list;
    }
}

