/*
 * Decompiled with CFR 0.152.
 */
package xyz.nucleoid.map_templates;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.class_11362;
import net.minecraft.class_11372;
import net.minecraft.class_1297;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2415;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_3532;
import net.minecraft.class_4076;
import net.minecraft.class_5321;
import net.minecraft.class_7225;
import net.minecraft.class_8942;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.nucleoid.map_templates.BlockBounds;
import xyz.nucleoid.map_templates.MapChunk;
import xyz.nucleoid.map_templates.MapEntity;
import xyz.nucleoid.map_templates.MapTemplateMetadata;
import xyz.nucleoid.map_templates.MapTransform;
import xyz.nucleoid.map_templates.TemplateRegion;

public final class MapTemplate {
    private static final Logger LOGGER = LoggerFactory.getLogger(MapTemplate.class);
    private static final class_2680 AIR = class_2246.field_10124.method_9564();
    final Long2ObjectMap<MapChunk> chunks = new Long2ObjectOpenHashMap();
    final Long2ObjectMap<class_2487> blockEntities = new Long2ObjectOpenHashMap();
    class_5321<class_1959> biome = class_1972.field_9473;
    BlockBounds bounds = null;
    BlockBounds generatedBounds = null;
    MapTemplateMetadata metadata = new MapTemplateMetadata();

    private MapTemplate() {
    }

    public static MapTemplate createEmpty() {
        return new MapTemplate();
    }

    public void setBiome(class_5321<class_1959> biome) {
        this.biome = biome;
    }

    public class_5321<class_1959> getBiome() {
        return this.biome;
    }

    public MapTemplateMetadata getMetadata() {
        return this.metadata;
    }

    public void setBlockState(class_2338 pos, class_2680 state) {
        MapChunk chunk = this.getOrCreateChunk(MapTemplate.chunkPos(pos));
        chunk.set(pos.method_10263() & 0xF, pos.method_10264() & 0xF, pos.method_10260() & 0xF, state);
        this.generatedBounds = null;
        if (state.method_31709()) {
            class_2487 nbt = new class_2487();
            nbt.method_10582("id", "DUMMY");
            nbt.method_10569("x", pos.method_10263());
            nbt.method_10569("y", pos.method_10264());
            nbt.method_10569("z", pos.method_10260());
            this.blockEntities.put(pos.method_10063(), (Object)nbt);
        }
    }

    public void setBlockEntity(class_2338 pos, @Nullable class_2586 entity, class_7225.class_7874 registryLookup) {
        if (entity != null) {
            try (class_8942.class_11340 errorReporter = new class_8942.class_11340(entity.method_71402(), LOGGER);){
                class_11362 view = class_11362.method_71459((class_8942)errorReporter, (class_7225.class_7874)registryLookup);
                entity.method_38243((class_11372)view);
                this.setBlockEntityNbt(pos, view.method_71475());
            }
        } else {
            this.setBlockEntityNbt(pos, null);
        }
    }

    public void setBlockEntityNbt(class_2338 pos, @Nullable class_2487 entityNbt) {
        if (entityNbt != null) {
            entityNbt.method_10569("x", pos.method_10263());
            entityNbt.method_10569("y", pos.method_10264());
            entityNbt.method_10569("z", pos.method_10260());
            this.blockEntities.put(pos.method_10063(), (Object)entityNbt);
        } else {
            this.blockEntities.remove(pos.method_10063());
        }
    }

    public class_2680 getBlockState(class_2338 pos) {
        MapChunk chunk = (MapChunk)this.chunks.get(MapTemplate.chunkPos(pos));
        if (chunk != null) {
            return chunk.get(pos.method_10263() & 0xF, pos.method_10264() & 0xF, pos.method_10260() & 0xF);
        }
        return AIR;
    }

    @Nullable
    public class_2487 getBlockEntityNbt(class_2338 localPos) {
        class_2487 nbt = (class_2487)this.blockEntities.get(localPos.method_10063());
        return nbt != null ? nbt.method_10553() : null;
    }

    @Nullable
    public class_2487 getBlockEntityNbt(class_2338 localPos, class_2338 worldPos) {
        class_2487 nbt = this.getBlockEntityNbt(localPos);
        if (nbt != null) {
            nbt.method_10569("x", worldPos.method_10263());
            nbt.method_10569("y", worldPos.method_10264());
            nbt.method_10569("z", worldPos.method_10260());
            return nbt;
        }
        return null;
    }

    public void addEntity(class_1297 entity, class_243 pos) {
        this.getOrCreateChunk(MapTemplate.chunkPos(pos)).addEntity(entity, pos);
    }

    public void addEntity(MapEntity entity) {
        this.getOrCreateChunk(MapTemplate.chunkPos(entity.position())).addEntity(entity);
    }

    public Stream<MapEntity> getEntitiesInChunk(int chunkX, int chunkY, int chunkZ) {
        MapChunk chunk = (MapChunk)this.chunks.get(MapTemplate.chunkPos(chunkX, chunkY, chunkZ));
        return chunk != null ? chunk.getEntities().stream() : Stream.empty();
    }

    public int getTopY(int x, int z, class_2902.class_2903 heightmap) {
        Predicate predicate = heightmap.method_16402();
        BlockBounds bounds = this.getBounds();
        int minY = bounds.min().method_10264();
        int maxY = bounds.max().method_10264();
        class_2338.class_2339 mutablePos = new class_2338.class_2339(x, 0, z);
        for (int y = maxY; y >= minY; --y) {
            mutablePos.method_33098(y);
            class_2680 state = this.getBlockState((class_2338)mutablePos);
            if (!predicate.test(state)) continue;
            return y;
        }
        return 0;
    }

    public class_2338 getTopPos(int x, int z, class_2902.class_2903 heightmap) {
        int y = this.getTopY(x, z, heightmap);
        return new class_2338(x, y, z);
    }

    public boolean containsBlock(class_2338 pos) {
        return this.getBlockState(pos) != AIR;
    }

    @NotNull
    public MapChunk getOrCreateChunk(long pos) {
        MapChunk chunk = (MapChunk)this.chunks.get(pos);
        if (chunk == null) {
            chunk = new MapChunk(class_4076.method_18677((long)pos));
            this.chunks.put(pos, (Object)chunk);
        }
        return chunk;
    }

    @Nullable
    public MapChunk getChunk(long pos) {
        return (MapChunk)this.chunks.get(pos);
    }

    public void setBounds(BlockBounds bounds) {
        this.bounds = bounds;
        this.generatedBounds = null;
    }

    public BlockBounds getBounds() {
        BlockBounds bounds = this.bounds;
        if (bounds != null) {
            return bounds;
        }
        BlockBounds generatedBounds = this.generatedBounds;
        if (generatedBounds == null) {
            this.generatedBounds = generatedBounds = this.computeBounds();
        }
        return generatedBounds;
    }

    @Nullable
    private BlockBounds getBoundsOrNull() {
        BlockBounds bounds = this.bounds;
        return bounds != null ? bounds : this.generatedBounds;
    }

    private BlockBounds computeBounds() {
        int minChunkX = Integer.MAX_VALUE;
        int minChunkY = Integer.MAX_VALUE;
        int minChunkZ = Integer.MAX_VALUE;
        int maxChunkX = Integer.MIN_VALUE;
        int maxChunkY = Integer.MIN_VALUE;
        int maxChunkZ = Integer.MIN_VALUE;
        for (Long2ObjectMap.Entry entry : Long2ObjectMaps.fastIterable(this.chunks)) {
            long chunkPos = entry.getLongKey();
            int chunkX = class_4076.method_18686((long)chunkPos);
            int chunkY = class_4076.method_18689((long)chunkPos);
            int chunkZ = class_4076.method_18690((long)chunkPos);
            if (chunkX < minChunkX) {
                minChunkX = chunkX;
            }
            if (chunkY < minChunkY) {
                minChunkY = chunkY;
            }
            if (chunkZ < minChunkZ) {
                minChunkZ = chunkZ;
            }
            if (chunkX > maxChunkX) {
                maxChunkX = chunkX;
            }
            if (chunkY > maxChunkY) {
                maxChunkY = chunkY;
            }
            if (chunkZ <= maxChunkZ) continue;
            maxChunkZ = chunkZ;
        }
        return BlockBounds.of(minChunkX << 4, minChunkY << 4, minChunkZ << 4, (maxChunkX << 4) + 15, (maxChunkY << 4) + 15, (maxChunkZ << 4) + 15);
    }

    static long chunkPos(class_2338 pos) {
        return MapTemplate.chunkPos(pos.method_10263() >> 4, pos.method_10264() >> 4, pos.method_10260() >> 4);
    }

    static long chunkPos(class_243 pos) {
        return MapTemplate.chunkPos(class_3532.method_15357((double)pos.method_10216()) >> 4, class_3532.method_15357((double)pos.method_10214()) >> 4, class_3532.method_15357((double)pos.method_10215()) >> 4);
    }

    static long chunkPos(int x, int y, int z) {
        return class_4076.method_18685((int)x, (int)y, (int)z);
    }

    public MapTemplate translated(int x, int y, int z) {
        return this.transformed(MapTransform.translation(x, y, z));
    }

    public MapTemplate rotateAround(class_2338 pivot, class_2470 rotation, class_2415 mirror) {
        return this.transformed(MapTransform.rotationAround(pivot, rotation, mirror));
    }

    public MapTemplate rotate(class_2470 rotation, class_2415 mirror) {
        return this.rotateAround(class_2338.field_10980, rotation, mirror);
    }

    public MapTemplate rotate(class_2470 rotation) {
        return this.rotate(rotation, class_2415.field_11302);
    }

    public MapTemplate mirror(class_2415 mirror) {
        return this.rotate(class_2470.field_11467, mirror);
    }

    public MapTemplate transformed(MapTransform transform) {
        MapTemplate result = MapTemplate.createEmpty();
        class_2338.class_2339 mutablePos = new class_2338.class_2339();
        for (MapChunk chunk : this.chunks.values()) {
            class_2338 minChunkPos = chunk.getPos().method_19767();
            for (int chunkZ = 0; chunkZ < 16; ++chunkZ) {
                for (int chunkY = 0; chunkY < 16; ++chunkY) {
                    for (int chunkX = 0; chunkX < 16; ++chunkX) {
                        class_2680 state = chunk.get(chunkX, chunkY, chunkZ);
                        if (state.method_26215()) continue;
                        state = transform.transformedBlock(state);
                        mutablePos.method_25504((class_2382)minChunkPos, chunkX, chunkY, chunkZ);
                        result.setBlockState((class_2338)transform.transformPoint(mutablePos), state);
                    }
                }
            }
            for (MapEntity entity : chunk.getEntities()) {
                result.addEntity(entity.transformed(transform));
            }
        }
        for (Long2ObjectMap.Entry blockEntity : Long2ObjectMaps.fastIterable(this.blockEntities)) {
            mutablePos.method_16363(blockEntity.getLongKey());
            transform.transformPoint(mutablePos);
            class_2487 nbt = ((class_2487)blockEntity.getValue()).method_10553();
            result.setBlockEntityNbt((class_2338)mutablePos, nbt);
        }
        result.biome = this.biome;
        result.metadata.data = this.metadata.data.method_10553();
        for (TemplateRegion sourceRegion : this.metadata.regions) {
            result.metadata.regions.add(new TemplateRegion(sourceRegion.getMarker(), transform.transformedBounds(sourceRegion.getBounds()), sourceRegion.getData().method_10553()));
        }
        return result;
    }

    public static MapTemplate merged(MapTemplate primary, MapTemplate secondary) {
        MapTemplate result = MapTemplate.createEmpty();
        secondary.mergeInto(result);
        primary.mergeInto(result);
        return result;
    }

    public void mergeFrom(MapTemplate other) {
        other.mergeInto(this);
    }

    public void mergeInto(MapTemplate other) {
        for (Long2ObjectMap.Entry entry : Long2ObjectMaps.fastIterable(this.chunks)) {
            long chunkPos = entry.getLongKey();
            MapChunk chunk = (MapChunk)entry.getValue();
            MapChunk otherChunk = other.getOrCreateChunk(chunkPos);
            for (int chunkZ = 0; chunkZ < 16; ++chunkZ) {
                for (int chunkY = 0; chunkY < 16; ++chunkY) {
                    for (int chunkX = 0; chunkX < 16; ++chunkX) {
                        class_2680 state = chunk.get(chunkX, chunkY, chunkZ);
                        if (state.method_26215()) continue;
                        otherChunk.set(chunkX, chunkY, chunkZ, state);
                    }
                }
            }
            for (MapEntity entity : chunk.getEntities()) {
                otherChunk.addEntity(entity);
            }
        }
        other.metadata.data.method_10543(this.metadata.data);
        for (TemplateRegion region : this.metadata.regions) {
            other.metadata.addRegion(region.copy());
        }
        other.bounds = this.getBounds().union(other.getBounds());
        other.biome = this.biome;
    }
}

