/*
 * Decompiled with CFR 0.152.
 */
package xyz.nucleoid.map_templates;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_2487;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.map_templates.BlockBounds;
import xyz.nucleoid.map_templates.TemplateRegion;

public final class MapTemplateMetadata {
    final List<TemplateRegion> regions = new ArrayList<TemplateRegion>();
    class_2487 data = new class_2487();

    public TemplateRegion addRegion(String marker, BlockBounds bounds) {
        return this.addRegion(marker, bounds, new class_2487());
    }

    public TemplateRegion addRegion(String marker, BlockBounds bounds, class_2487 nbt) {
        TemplateRegion region = new TemplateRegion(marker, bounds, nbt);
        this.regions.add(region);
        return region;
    }

    public void addRegion(TemplateRegion region) {
        this.regions.add(region);
    }

    public Stream<TemplateRegion> getRegions(String marker) {
        return this.regions.stream().filter(region -> region.getMarker().equals(marker));
    }

    public Stream<BlockBounds> getRegionBounds(String marker) {
        return this.getRegions(marker).map(TemplateRegion::getBounds);
    }

    @Nullable
    public TemplateRegion getFirstRegion(String marker) {
        return this.getRegions(marker).findFirst().orElse(null);
    }

    @Nullable
    public BlockBounds getFirstRegionBounds(String marker) {
        return this.getRegionBounds(marker).findFirst().orElse(null);
    }

    public Collection<TemplateRegion> getRegions() {
        return this.regions;
    }

    public void setData(class_2487 data) {
        this.data = data;
    }

    public class_2487 getData() {
        return this.data;
    }
}

