/*
 * Decompiled with CFR 0.152.
 */
package xyz.nucleoid.map_templates;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.stream.Stream;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_3218;
import net.minecraft.class_4076;
import xyz.nucleoid.map_templates.BlockBounds;
import xyz.nucleoid.map_templates.MapEntity;
import xyz.nucleoid.map_templates.MapTemplate;

public record MapTemplatePlacer(MapTemplate template) {
    public void placeAt(class_3218 world, class_2338 origin) {
        Long2ObjectMap<class_2818> chunkCache = this.collectChunks(world, origin, this.template.bounds);
        this.placeBlocks(origin, chunkCache);
        this.placeEntities(world, origin);
    }

    private Long2ObjectMap<class_2818> collectChunks(class_3218 world, class_2338 origin, BlockBounds bounds) {
        LongSet chunkPositions = bounds.offset(origin).asChunks();
        LongIterator chunkIterator = chunkPositions.iterator();
        Long2ObjectOpenHashMap chunks = new Long2ObjectOpenHashMap(chunkPositions.size());
        while (chunkIterator.hasNext()) {
            long chunkPos = chunkIterator.nextLong();
            int chunkX = class_1923.method_8325((long)chunkPos);
            int chunkZ = class_1923.method_8332((long)chunkPos);
            chunks.put(chunkPos, (Object)world.method_8497(chunkX, chunkZ));
        }
        return chunks;
    }

    private void placeBlocks(class_2338 origin, Long2ObjectMap<class_2818> chunkCache) {
        MapTemplate template = this.template;
        BlockBounds bounds = template.getBounds();
        class_2338.class_2339 worldPos = new class_2338.class_2339();
        int originX = origin.method_10263();
        int originY = origin.method_10264();
        int originZ = origin.method_10260();
        for (class_2338 templatePos : bounds) {
            worldPos.method_25504((class_2382)templatePos, originX, originY, originZ);
            class_2680 state = template.getBlockState(templatePos);
            if (state.method_26215()) continue;
            int chunkX = worldPos.method_10263() >> 4;
            int chunkZ = worldPos.method_10260() >> 4;
            long chunkPos = class_1923.method_8331((int)chunkX, (int)chunkZ);
            class_2818 chunk = (class_2818)chunkCache.get(chunkPos);
            class_2487 blockEntity = template.getBlockEntityNbt(templatePos, (class_2338)worldPos);
            if (blockEntity != null) {
                chunk.method_12042(blockEntity);
            }
            chunk.method_66480((class_2338)worldPos, state);
        }
    }

    private void placeEntities(class_3218 world, class_2338 origin) {
        MapTemplate template = this.template;
        LongSet chunks = template.getBounds().asChunkSections();
        LongIterator chunkIterator = chunks.iterator();
        while (chunkIterator.hasNext()) {
            long chunkPos = chunkIterator.nextLong();
            int chunkX = class_4076.method_18686((long)chunkPos);
            int chunkY = class_4076.method_18689((long)chunkPos);
            int chunkZ = class_4076.method_18690((long)chunkPos);
            Stream<MapEntity> entities = template.getEntitiesInChunk(chunkX, chunkY, chunkZ);
            entities.forEach(mapEntity -> mapEntity.createEntities((class_1937)world, origin, arg_0 -> ((class_3218)world).method_8649(arg_0)));
        }
    }
}

