/*
 * Decompiled with CFR 0.152.
 */
package xyz.nucleoid.map_templates;

import com.google.common.base.Strings;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFixer;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Optional;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1208;
import net.minecraft.class_155;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3551;
import net.minecraft.class_4076;
import net.minecraft.class_5321;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import xyz.nucleoid.map_templates.BlockBounds;
import xyz.nucleoid.map_templates.MapChunk;
import xyz.nucleoid.map_templates.MapTemplate;
import xyz.nucleoid.map_templates.MapTemplateMetadata;
import xyz.nucleoid.map_templates.TemplateRegion;

public final class MapTemplateSerializer {
    private static final Logger LOGGER = LogManager.getLogger(MapTemplateSerializer.class);
    private static final boolean SKIP_FIXERS = FabricLoader.getInstance().isModLoaded("databreaker");

    private MapTemplateSerializer() {
    }

    public static MapTemplate loadFromResource(MinecraftServer server, class_2960 identifier) throws IOException {
        class_2960 path = MapTemplateSerializer.getResourcePathFor(identifier);
        class_3300 resourceManager = server.method_34864();
        Optional resource = resourceManager.method_14486(path);
        if (resource.isEmpty()) {
            throw new IOException("No resource found for " + String.valueOf(identifier));
        }
        return MapTemplateSerializer.loadFrom(((class_3298)resource.get()).method_14482(), (class_7225.class_7874)server.method_30611());
    }

    public static MapTemplate loadFrom(InputStream input, class_7225.class_7874 registryLookup) throws IOException {
        MapTemplate template = MapTemplate.createEmpty();
        MapTemplateSerializer.load(template, class_2507.method_10629((InputStream)input, (class_2505)class_2505.method_53898()), registryLookup);
        return template;
    }

    public static void saveTo(MapTemplate template, OutputStream output, class_7225.class_7874 registryLookup) throws IOException {
        class_2487 root = MapTemplateSerializer.save(template, registryLookup);
        class_2507.method_10634((class_2487)root, (OutputStream)output);
    }

    private static int getDataVersion(class_2487 root) {
        return root.method_68083("data_version", 2586);
    }

    private static int getCurrentDataVersion() {
        return class_155.method_16673().comp_4026().comp_4038();
    }

    private static void load(MapTemplate template, class_2487 root, class_7225.class_7874 registryLookup) {
        MapTemplateSerializer.load(template, root, registryLookup, class_3551.method_15450());
    }

    private static void load(MapTemplate template, class_2487 root, class_7225.class_7874 registryLookup, DataFixer fixer) {
        class_2960 biomeId;
        int oldVersion = MapTemplateSerializer.getDataVersion(root);
        int targetVersion = MapTemplateSerializer.getCurrentDataVersion();
        class_2499 chunkList = root.method_68569("chunks");
        for (int i = 0; i < chunkList.size(); ++i) {
            class_2487 chunkRoot = chunkList.method_68582(i);
            if (targetVersion > oldVersion) {
                class_2499 palette;
                if (oldVersion <= 2730) {
                    palette = chunkRoot.method_68569("palette");
                    long[] blockData = chunkRoot.method_10565("block_states").orElseGet(() -> new long[0]);
                    chunkRoot.method_10551("palette");
                    class_2487 blockStates = new class_2487();
                    blockStates.method_10564("data", blockData);
                    blockStates.method_10566("palette", (class_2520)palette);
                    chunkRoot.method_10566("block_states", (class_2520)blockStates);
                }
                if (!SKIP_FIXERS) {
                    palette = chunkRoot.method_68568("block_states").method_68569("palette");
                    MapTemplateSerializer.updateList(palette, fixer, class_1208.field_5720, oldVersion, targetVersion);
                    class_2499 entities = chunkRoot.method_68569("entities");
                    MapTemplateSerializer.updateList(entities, fixer, class_1208.field_5729, oldVersion, targetVersion);
                } else {
                    LOGGER.error("Couldn't apply datafixers to template because databreaker is present!");
                }
            }
            chunkRoot.method_67491("pos", class_2382.field_25123).ifPresentOrElse(posArray -> {
                long pos = MapTemplate.chunkPos(posArray.method_10263(), posArray.method_10264(), posArray.method_10260());
                MapChunk chunk = MapChunk.deserialize(class_4076.method_18677((long)pos), chunkRoot, registryLookup);
                template.chunks.put(pos, (Object)chunk);
            }, () -> LOGGER.warn("Invalid chunk pos key: {}", (Object)chunkRoot.method_10580("pos")));
        }
        MapTemplateMetadata metadata = template.metadata;
        class_2499 regionList = root.method_68569("regions");
        for (int i = 0; i < regionList.size(); ++i) {
            class_2487 regionRoot = regionList.method_68582(i);
            metadata.regions.add(TemplateRegion.deserialize(regionRoot));
        }
        class_2499 blockEntityList = root.method_68569("block_entities");
        for (int i = 0; i < blockEntityList.size(); ++i) {
            class_2487 blockEntity = blockEntityList.method_68582(i);
            if (targetVersion > oldVersion && !SKIP_FIXERS) {
                Dynamic dynamic = new Dynamic((DynamicOps)class_2509.field_11560, (Object)blockEntity);
                blockEntity = (class_2487)fixer.update(class_1208.field_5727, dynamic, oldVersion, targetVersion).getValue();
            }
            class_2338 pos = new class_2338(blockEntity.method_68083("x", 0), blockEntity.method_68083("y", 0), blockEntity.method_68083("z", 0));
            template.blockEntities.put(pos.method_10063(), (Object)blockEntity);
        }
        template.bounds = BlockBounds.deserialize(root.method_10562("bounds").orElse(null));
        metadata.data = root.method_10562("data").orElse(null);
        String biomeIdString = root.method_10558("biome").orElse("");
        if (!Strings.isNullOrEmpty((String)biomeIdString) && (biomeId = class_2960.method_12829((String)biomeIdString)) != null) {
            template.biome = class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)biomeId);
        }
    }

    private static void updateList(class_2499 list, DataFixer fixer, DSL.TypeReference type, int oldVersion, int targetVersion) {
        if (list == null) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            class_2487 nbt = list.method_68582(i);
            Dynamic dynamic = new Dynamic((DynamicOps)class_2509.field_11560, (Object)nbt);
            list.method_68585(i, (class_2520)fixer.update(type, dynamic, oldVersion, targetVersion).getValue());
        }
    }

    private static class_2487 save(MapTemplate template, class_7225.class_7874 registryLookup) {
        class_2487 root = new class_2487();
        int dataVersion = MapTemplateSerializer.getCurrentDataVersion();
        root.method_10569("data_version", dataVersion);
        class_2499 chunkList = new class_2499();
        for (Long2ObjectMap.Entry entry : Long2ObjectMaps.fastIterable(template.chunks)) {
            class_4076 pos = class_4076.method_18677((long)entry.getLongKey());
            MapChunk chunk = (MapChunk)entry.getValue();
            class_2487 chunkRoot = new class_2487();
            chunkRoot.method_10539("pos", new int[]{pos.method_10263(), pos.method_10264(), pos.method_10260()});
            chunk.serialize(chunkRoot, registryLookup);
            chunkList.add((Object)chunkRoot);
        }
        root.method_10566("chunks", (class_2520)chunkList);
        class_2499 blockEntityList = new class_2499();
        blockEntityList.addAll((Collection)template.blockEntities.values());
        root.method_10566("block_entities", (class_2520)blockEntityList);
        root.method_10566("bounds", (class_2520)template.bounds.serialize(new class_2487()));
        if (template.biome != null) {
            root.method_10582("biome", template.biome.method_29177().toString());
        }
        MapTemplateMetadata metadata = template.metadata;
        class_2499 regionList = new class_2499();
        for (TemplateRegion region : metadata.regions) {
            regionList.add((Object)region.serialize(new class_2487()));
        }
        root.method_10566("regions", (class_2520)regionList);
        root.method_10566("data", (class_2520)metadata.data);
        return root;
    }

    public static class_2960 getResourcePathFor(class_2960 identifier) {
        return identifier.method_45134(path -> "map_template/" + path + ".nbt");
    }
}

