/*
 * Decompiled with CFR 0.152.
 */
package xyz.nucleoid.packettweaker;

import com.mojang.authlib.GameProfile;
import net.minecraft.class_2535;
import net.minecraft.class_2547;
import net.minecraft.class_2596;
import net.minecraft.class_3222;
import net.minecraft.class_7225;
import net.minecraft.class_8791;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.packettweaker.ContextProvidingPacketListener;
import xyz.nucleoid.packettweaker.impl.ConnectionClientAttachment;

public final class PacketContext {
    private static final ThreadLocal<PacketContext> INSTANCE = ThreadLocal.withInitial(PacketContext::new);
    private ContextProvidingPacketListener target = ContextProvidingPacketListener.EMPTY;
    @Nullable
    private class_2596<?> encodedPacket = null;
    @Nullable
    private class_2535 connection = null;

    public static PacketContext get() {
        return INSTANCE.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runWithContext(@Nullable class_2535 connection, @Nullable class_2547 networkHandler, @Nullable class_2596<?> packet, Runnable runnable) {
        PacketContext context = PacketContext.get();
        ContextProvidingPacketListener oldTarget = context.target;
        class_2596<?> oldPacket = context.encodedPacket;
        class_2535 oldConnection = context.connection;
        context.target = ContextProvidingPacketListener.of(networkHandler);
        context.encodedPacket = packet;
        context.connection = connection;
        try {
            runnable.run();
        }
        finally {
            context.target = oldTarget;
            context.encodedPacket = oldPacket;
            context.connection = oldConnection;
        }
    }

    public static void runWithContext(@Nullable class_2547 networkHandler, @Nullable class_2596<?> packet, Runnable runnable) {
        PacketContext.runWithContext(ContextProvidingPacketListener.getClientConnection(networkHandler), networkHandler, packet, runnable);
    }

    public static void runWithContext(@Nullable class_2547 networkHandler, Runnable runnable) {
        PacketContext.runWithContext(networkHandler, null, runnable);
    }

    public static PacketContext of(class_3222 player) {
        return PacketContext.of((class_2547)player.field_13987);
    }

    public static PacketContext of(class_2547 listener) {
        PacketContext ctx = new PacketContext();
        ctx.target = (ContextProvidingPacketListener)listener;
        ctx.connection = ctx.target.getClientConnectionForPacketTweaker();
        return ctx;
    }

    public static PacketContext of(class_2535 connection) {
        PacketContext ctx = new PacketContext();
        ctx.target = (ContextProvidingPacketListener)connection.method_10744();
        ctx.connection = connection;
        return ctx;
    }

    public static PacketContext of() {
        return new PacketContext();
    }

    @ApiStatus.Internal
    public static void setContext(@Nullable class_2535 connection, @Nullable class_2596<?> packet) {
        if (connection == null) {
            PacketContext.clearContext();
            return;
        }
        PacketContext context = PacketContext.get();
        context.target = (ContextProvidingPacketListener)connection.method_10744();
        context.connection = connection;
        context.encodedPacket = packet;
    }

    @ApiStatus.Internal
    public static void clearContext() {
        PacketContext context = PacketContext.get();
        context.target = ContextProvidingPacketListener.EMPTY;
        context.connection = null;
        context.encodedPacket = null;
    }

    @Deprecated
    @Nullable
    public class_3222 getTarget() {
        return this.getPlayer();
    }

    @Nullable
    public class_3222 getPlayer() {
        return this.target.getPlayerForPacketTweaker();
    }

    @Nullable
    public class_8791 getClientOptions() {
        return this.target.getClientOptionsForPacketTweaker();
    }

    @Nullable
    public GameProfile getGameProfile() {
        return this.target.getGameProfileForPacketTweaker();
    }

    @Nullable
    public class_7225.class_7874 getRegistryWrapperLookup() {
        return this.target.getWrapperLookupForPacketTweaker();
    }

    public ContextProvidingPacketListener getPacketListener() {
        return this.target;
    }

    @Nullable
    public class_2547 getBackingPacketListener() {
        return this.target != ContextProvidingPacketListener.EMPTY ? (class_2547)this.target : null;
    }

    @Nullable
    public class_2535 getClientConnection() {
        return this.connection;
    }

    @Nullable
    public <T> T getData(Key<T> key) {
        return PacketContext.getData(this.connection, key);
    }

    @Nullable
    public <T> T setData(Key<T> key, @Nullable T data) {
        return PacketContext.setData(this.connection, key, data);
    }

    @Nullable
    public class_2596<?> getEncodedPacket() {
        return this.encodedPacket;
    }

    @Nullable
    public static <T> T getData(class_2547 listener, Key<T> key) {
        return PacketContext.getData(((ContextProvidingPacketListener)listener).getClientConnectionForPacketTweaker(), key);
    }

    @Nullable
    public static <T> T setData(class_2547 listener, Key<T> key, @Nullable T data) {
        return PacketContext.setData(((ContextProvidingPacketListener)listener).getClientConnectionForPacketTweaker(), key, data);
    }

    @Nullable
    public static <T> T getData(class_2535 connection, Key<T> key) {
        if (connection == null) {
            return null;
        }
        return ((ConnectionClientAttachment)connection).packetTweaker$get(key);
    }

    @Nullable
    public static <T> T setData(class_2535 connection, Key<T> key, @Nullable T data) {
        if (connection == null) {
            return null;
        }
        return ((ConnectionClientAttachment)connection).packetTweaker$set(key, data);
    }

    public static final class Key<T> {
        private final String id;

        private Key(String id) {
            this.id = id;
        }

        public static <T> Key<T> of(String id) {
            return new Key<T>(id);
        }

        public String toString() {
            return "Key[" + this.id + "]";
        }
    }
}

