package xyz.nucleoid.plasmid.api.game;

import net.minecraft.class_6880;
import xyz.nucleoid.plasmid.api.game.config.GameConfig;

/**
 * Holds the logic controlling how a {@link GameSpace} should be opened.
 *
 * @see GameOpenContext
 */
public interface GameOpenProcedure {
    static GameOpenProcedure withOverride(GameOpenProcedure procedure, class_6880<GameConfig<?>> game) {
        return new GameOpenProcedure() {
            @Override
            public void apply(GameSpace context) {
                procedure.apply(context);
            }

            @Override
            public class_6880<GameConfig<?>> configOverride() {
                return game;
            }
        };
    }

    void apply(GameSpace gameSpace);

    default class_6880<GameConfig<?>> configOverride() {
        return null;
    }
}
