package xyz.nucleoid.plasmid.api.game;

import com.mojang.serialization.MapCodec;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.plasmid.api.game.config.GameConfig;
import xyz.nucleoid.plasmid.api.registry.PlasmidRegistries;
import xyz.nucleoid.plasmid.api.util.TinyRegistry;

import java.util.function.Consumer;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

/**
 * Represents a specific "type" of game. A {@link GameType} is simply responsible for taking a configuration object
 * and setting up game state.
 * <p>
 * A {@link GameType} cannot be directly interacted with from inside the game, but is instead referenced through game
 * configurations which are stored in a datapack.
 *
 * @param <C> the type of config that should be loaded
 * @see GameConfig
 */
public final class GameType<C> {
    /**
     * @deprecated Use {@link PlasmidRegistries#GAME_TYPE} instead.
     */
    @Deprecated
    public static final TinyRegistry<GameType<?>> REGISTRY = new TinyRegistry.Fake(PlasmidRegistries.GAME_TYPE);

    private final class_2960 id;
    private final MapCodec<C> configCodec;
    private final Open<C> open;

    GameType(class_2960 id, MapCodec<C> configCodec, Open<C> open) {
        this.id = id;
        this.configCodec = configCodec;
        this.open = open;
    }

    /**
     * Registers a new {@link GameType} with the given id, codec to parse a config, and function to set up the game.
     *
     * @param identifier a unique identifier to register this game type with
     * @param configCodec a {@link MapCodec} that can deserialize
     * @param open a function that describes how the game should be set up, given a configuration
     * @param <C> the type of config that should be loadedS
     * @return the registered {@link GameType} instance
     * @see MapCodec
     * @see com.mojang.serialization.codecs.RecordCodecBuilder
     *
     * @deprecated Use {@link GameTypes#register(class_2960, MapCodec, Open)} instead.
     */
    @Deprecated
    public static <C> GameType<C> register(class_2960 identifier, MapCodec<C> configCodec, Open<C> open) {
        return GameTypes.register(identifier, configCodec, open);
    }

    public GameOpenProcedure open(GameOpenContext<C> context) {
        return this.open.open(context);
    }

    public class_2960 id() {
        return this.id;
    }

    public MapCodec<C> configCodec() {
        return this.configCodec;
    }

    public class_2561 name() {
        return class_2561.method_43471(this.translationKey());
    }

    public String translationKey() {
        return class_156.method_646("gameType", this.id);
    }

    @Nullable
    public static GameType<?> get(class_2960 identifier) {
        return PlasmidRegistries.GAME_TYPE.method_63535(identifier);
    }

    public interface Open<C> {
        /**
         * Given a game configuration, returns a {@link GameOpenProcedure} describing how this game should be opened.
         * <p>
         * This code runs off-thread, so all blocking or slow operations should run here. Logic interacting with the
         * game should be run in the {@link GameActivity} setup function (see {@link GameOpenContext#open(Consumer)}).
         *
         * @param context the context with which to construct a {@link GameOpenContext} and access configuration
         * @return a {@link GameOpenContext} describing how the game should be opened
         */
        GameOpenProcedure open(GameOpenContext<C> context);
    }
}
