package xyz.nucleoid.plasmid.api.game;

import com.mojang.serialization.MapCodec;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import xyz.nucleoid.plasmid.api.registry.PlasmidRegistries;
import xyz.nucleoid.plasmid.api.registry.PlasmidRegistryKeys;
import xyz.nucleoid.plasmid.impl.Plasmid;
import xyz.nucleoid.plasmid.impl.game.composite.RandomGame;
import xyz.nucleoid.plasmid.impl.game.composite.RandomGameConfig;

public class GameTypes {
    public static final GameType<RandomGameConfig> RANDOM = register("random", RandomGameConfig.CODEC, RandomGame::open);
    public static final GameType<String> INVALID = register("invalid", MapCodec.unit(""), (context) -> {
        var id = context.server().method_30611().method_30530(PlasmidRegistryKeys.GAME_CONFIG).method_10221(context.game());
        throw new GameOpenException(class_2561.method_43469("text.plasmid.map.open.invalid_game", id != null ? id.toString() : context.game()));
    });

    public static GameType<?> register(class_2960 key, GameType<?> type) {
        return class_2378.method_10230(PlasmidRegistries.GAME_TYPE, key, type);
    }

    public static <C> GameType<C> register(class_2960 key, MapCodec<C> configCodec, GameType.Open<C> open) {
        var type = new GameType<>(key, configCodec, open);
        register(key, type);
        return type;
    }

    public static <C> GameType<C> register(String key, MapCodec<C> configCodec, GameType.Open<C> open) {
        return register(Plasmid.id(key), configCodec, open);
    }
}
