package xyz.nucleoid.plasmid.api.game.common;

import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3489;
import net.minecraft.class_5134;
import net.minecraft.class_6880;
import net.minecraft.class_9274;
import net.minecraft.class_9334;
import net.minecraft.class_9886;
import net.minecraft.item.*;

/**
 * A utility class that allows old-style 1.8 combat to be applied to any given {@link class_1799}.
 * <p>
 * This works by modifying the damage and attack speed attributes to match their 1.8 levels.
 */
public final class OldCombat {
    private static final class_6880<class_1320> DAMAGE_ATTRIBUTE = class_5134.field_23721;
    private static final class_6880<class_1320> SPEED_ATTRIBUTE = class_5134.field_23723;

    private static final class_2960 DAMAGE_ID = class_1792.field_8006;
    private static final class_2960 SPEED_ID = class_1792.field_8001;

    private static final class_9886[] TOOL_MATERIALS = {
            class_9886.field_52585,
            class_9886.field_52589,
            class_9886.field_52586,
            class_9886.field_52587,
            class_9886.field_52588,
            class_9886.field_52590
    };

    private static final int HOE_BASE_DAMAGE = 0;
    private static final int SHOVEL_BASE_DAMAGE = 0;
    private static final int PICKAXE_BASE_DAMAGE = 1;
    private static final int AXE_BASE_DAMAGE = 2;
    private static final int SWORD_BASE_DAMAGE = 3;

    public static class_1799 applyTo(class_1799 stack) {
        if (!stack.method_57826(class_9334.field_50077)) {
            return stack;
        }

        var material = getToolMaterial(stack);

        if (material == null) {
            return stack;
        }

        var defaultModifiers = stack.method_58694(class_9334.field_49636);

        {
            class_1322 modifier = createSpeedModifier();
            defaultModifiers = defaultModifiers.method_57484(SPEED_ATTRIBUTE, modifier, class_9274.field_49217);
        }

        {
            float attackDamageBonus = stack.method_31573(class_3489.field_42613) ? 0 : getToolMaterial(stack).comp_2933();
            int baseDamage = getBaseDamage(stack);

            class_1322 modifier = createDamageModifier(attackDamageBonus + baseDamage);
            defaultModifiers = defaultModifiers.method_57484(DAMAGE_ATTRIBUTE, modifier, class_9274.field_49217);
        }

        stack.method_57379(class_9334.field_49636, defaultModifiers);
        return stack;
    }

    private static class_1322 createSpeedModifier() {
        return new class_1322(SPEED_ID, 10000.0F, class_1322.class_1323.field_6328);
    }

    private static class_1322 createDamageModifier(double damage) {
        return new class_1322(DAMAGE_ID, damage, class_1322.class_1323.field_6328);
    }

    private static class_9886 getToolMaterial(class_1799 item) {
        for (var material : TOOL_MATERIALS) {
            var repairable = item.method_58694(class_9334.field_53696);

            if (repairable != null) {
                var repairItems = repairable.comp_2939().method_45925();

                if (repairItems.isPresent() && repairItems.get().equals(material.comp_2935())) {
                    return material;
                }
            }
        }

        return null;
    }

    private static int getBaseDamage(class_1799 stack) {
        if (stack.method_31573(class_3489.field_42611)) {
            return SWORD_BASE_DAMAGE;
        } else if (stack.method_31573(class_3489.field_42612)) {
            return AXE_BASE_DAMAGE;
        } else if (stack.method_31573(class_3489.field_42614)) {
            return PICKAXE_BASE_DAMAGE;
        } else if (stack.method_31573(class_3489.field_42615)) {
            return SHOVEL_BASE_DAMAGE;
        } else if (stack.method_31573(class_3489.field_42613)) {
            return HOE_BASE_DAMAGE;
        }
        return 0;
    }
}
