package xyz.nucleoid.plasmid.api.game.common.team;

import net.minecraft.class_2556;
import net.minecraft.class_3222;
import net.minecraft.class_7471;
import net.minecraft.class_7604;
import xyz.nucleoid.plasmid.api.chat.ChatChannel;
import xyz.nucleoid.plasmid.api.chat.HasChatChannel;
import xyz.nucleoid.plasmid.api.chat.PlasmidMessageTypes;
import xyz.nucleoid.plasmid.api.game.GameActivity;
import xyz.nucleoid.stimuli.event.player.ReplacePlayerChatEvent;

public final class TeamChat {
    private final TeamManager manager;

    private TeamChat(TeamManager manager) {
        this.manager = manager;
    }

    public static void addTo(GameActivity activity, TeamManager manager) {
        var teamChat = new TeamChat(manager);
        activity.listen(ReplacePlayerChatEvent.EVENT, teamChat::onSendMessage);
    }

    private boolean onSendMessage(class_3222 player, class_7471 message, class_2556.class_7602 messageType) {
        var team = this.manager.teamFor(player);

        if (team != null && player instanceof HasChatChannel hasChannel && hasChannel.getChatChannel() == ChatChannel.TEAM) {
            var teamName = this.manager.getTeamConfig(team).name();
            var teamMessageType = class_2556.method_44832(PlasmidMessageTypes.TEAM_CHAT, player).method_44839(teamName);

            var sentMessage = class_7604.method_44857(message);
            for (var receiver : this.manager.playersIn(team)) {
                receiver.method_43505(sentMessage, player.method_33795(receiver), teamMessageType);
            }

            return true;
        }

        return false;
    }
}
