package xyz.nucleoid.plasmid.api.game.common.team.provider;

import com.mojang.serialization.MapCodec;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import xyz.nucleoid.plasmid.api.registry.PlasmidRegistries;
import xyz.nucleoid.plasmid.impl.Plasmid;

/**
 * Types of {@link TeamListProvider} that can be registered in the registry ({@link PlasmidRegistries#TEAM_LIST_PROVIDER_TYPE}).
 *
 * @author Hugman
 */
public class TeamListProviderTypes {
    public static final MapCodec<ConstantTeamListProvider> CONSTANT = of("constant", ConstantTeamListProvider.CODEC);
    public static final MapCodec<TrimTeamListProvider> TRIM = of("trim", TrimTeamListProvider.CODEC);
    public static final MapCodec<RandomTeamListProvider> RANDOM = of("random", RandomTeamListProvider.CODEC);
    public static final MapCodec<SizedAlternativesTeamListProvider> SIZED_ALTERNATIVES = of("sized_alternatives", SizedAlternativesTeamListProvider.CODEC);

    private static <T extends TeamListProvider> MapCodec<T> of(String name, MapCodec<T> codec) {
        return of(class_2960.method_60655(Plasmid.ID, name), codec);
    }

    public static <T extends TeamListProvider> MapCodec<T> of(class_2960 identifier, MapCodec<T> codec) {
        return class_2378.method_10230(PlasmidRegistries.TEAM_LIST_PROVIDER_TYPE, identifier, codec);
    }
}
