package xyz.nucleoid.plasmid.api.game.player;

import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import xyz.nucleoid.plasmid.api.event.GameEvents;
import xyz.nucleoid.plasmid.api.game.*;
import xyz.nucleoid.plasmid.impl.Plasmid;

import java.util.Collection;
import java.util.Set;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

/**
 * Utility class for joining players to a {@link GameSpace}. This handles all logic such as collecting all party
 * members, and offering players to the {@link GameSpace}.
 */
public final class GamePlayerJoiner {
    public static GameResult tryJoin(class_3222 player, GameSpace gameSpace, JoinIntent intent) {
        try {
            var players = collectPlayersForJoin(player, gameSpace);
            return tryJoinAll(players, gameSpace, intent);
        } catch (Throwable throwable) {
            return handleJoinException(throwable);
        }
    }

    private static Set<class_3222> collectPlayersForJoin(class_3222 player, GameSpace gameSpace) {
        Set<class_3222> players = new ReferenceOpenHashSet<>();
        players.add(player);

        GameEvents.COLLECT_PLAYERS_FOR_JOIN.invoker().collectPlayersForJoin(gameSpace, player, players);

        return players;
    }

    private static GameResult tryJoinAll(Collection<class_3222> players, GameSpace gameSpace, JoinIntent intent) {
        return gameSpace.getPlayers().offer(players, intent);
    }

    public static GameResult handleJoinException(Throwable throwable) {
        Plasmid.LOGGER.error("Failed to add player to game space!", throwable);
        return GameResult.error(getFeedbackForException(throwable));
    }

    private static class_2561 getFeedbackForException(Throwable throwable) {
        var gameOpenException = GameOpenException.unwrap(throwable);
        if (gameOpenException != null) {
            return gameOpenException.getReason().method_27661();
        } else {
            return GameTexts.Join.unexpectedError();
        }
    }
}
