package xyz.nucleoid.plasmid.api.game.player;

import com.google.common.collect.AbstractIterator;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.plasmid.api.game.GameSpace;
import xyz.nucleoid.plasmid.api.util.PlayerRef;

import java.util.Iterator;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;

public final class MutablePlayerSet implements PlayerSet {
    private final Function<UUID, class_3222> playerGetter;

    private final Set<UUID> players = new ObjectOpenHashSet<>();

    public MutablePlayerSet(MinecraftServer server) {
        this.playerGetter = server.method_3760()::method_14602;
    }

    public MutablePlayerSet(class_3218 world) {
        this.playerGetter = (uuid) -> world.method_18470(uuid) instanceof class_3222 player ? player : null;
    }

    public MutablePlayerSet(GameSpace gameSpace) {
        this.playerGetter = gameSpace.getPlayers()::getEntity;
    }

    public void clear() {
        this.players.clear();
    }

    public boolean add(class_3222 player) {
        return this.players.add(player.method_5667());
    }

    public boolean add(PlayerRef ref) {
        return this.players.add(ref.id());
    }

    public boolean remove(class_3222 player) {
        return this.players.remove(player.method_5667());
    }

    public boolean remove(PlayerRef ref) {
        return this.players.remove(ref.id());
    }

    public boolean remove(UUID id) {
        return this.players.remove(id);
    }

    @Nullable
    @Override
    public class_3222 getEntity(UUID id) {
        return this.players.contains(id) ? this.playerGetter.apply(id) : null;
    }

    @Override
    public boolean contains(UUID id) {
        return this.players.contains(id);
    }

    @Override
    public @NotNull Iterator<class_3222> iterator() {
        var playerGetter = this.playerGetter;
        var ids = this.players.iterator();

        return new AbstractIterator<>() {
            @Override
            protected class_3222 computeNext() {
                while (ids.hasNext()) {
                    var id = ids.next();
                    var player = playerGetter.apply(id);
                    if (player != null) {
                        return player;
                    }
                }
                return this.endOfData();
            }
        };
    }

    @Override
    public int size() {
        return this.players.size();
    }
}
