package xyz.nucleoid.plasmid.api.game.player;

import java.util.Collections;
import java.util.Iterator;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.class_1293;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_5894;
import net.minecraft.class_5903;
import net.minecraft.class_5904;
import net.minecraft.class_5905;

/**
 * Represents an {@link Iterable} of {@link class_3222} on a server.
 *
 * @see PlayerSet
 * @see PlayerOps
 */
public interface PlayerIterable extends PlayerOps, Iterable<class_3222> {
    PlayerIterable EMPTY = Collections::emptyIterator;

    /**
     * @return an iterator over the online {@link class_3222} within this {@link PlayerIterable}
     */
    @Override
    Iterator<class_3222> iterator();

    /**
     * @return a stream of online {@link class_3222} within this {@link PlayerIterable}
     */
    default Stream<class_3222> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    @Override
    default void sendPacket(class_2596<?> packet) {
        for (var player : this) {
            player.field_13987.method_14364(packet);
        }
    }

    @Override
    default void sendMessage(class_2561 message) {
        for (var player : this) {
            player.method_7353(message, false);
        }
    }

    @Override
    default void showTitle(class_2561 title, int fadeInTicks, int stayTicks, int fadeOutTicks) {
        this.sendPacket(new class_5905(fadeInTicks, stayTicks, fadeOutTicks));
        this.sendPacket(new class_5904(title));
    }

    @Override
    default void showTitle(class_2561 title, class_2561 subtitle, int fadeInTicks, int stayTicks, int fadeOutTicks) {
        this.sendPacket(new class_5905(fadeInTicks, stayTicks, fadeOutTicks));
        this.sendPacket(new class_5904(title));
        this.sendPacket(new class_5903(subtitle));
    }

    @Override
    default void sendActionBar(class_2561 message) {
        for (var player : this) {
            player.method_7353(message, true);
        }
    }

    @Override
    default void sendActionBar(class_2561 message, int fadeInTicks, int stayTicks, int fadeOutTicks) {
        this.sendPacket(new class_5905(fadeInTicks, stayTicks, fadeOutTicks));
        this.sendPacket(new class_5894(message));
    }

    @Override
    default void playSound(class_3414 sound) {
        this.playSound(sound, class_3419.field_15248, 1.0F, 1.0F);
    }

    @Override
    default void playSound(class_3414 sound, class_3419 category, float volume, float pitch) {
        for (var player : this) {
            player.method_17356(sound, category, volume, pitch);
        }
    }

    @Override
    default void addStatusEffect(class_1293 effect) {
        for (var player : this) {
            player.method_6092(effect);
        }
    }
}
