package xyz.nucleoid.plasmid.api.game.player;

import net.minecraft.class_1293;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_3414;
import net.minecraft.class_3419;

/**
 * A utility interface that allows various operations to be applied to a group of players such as sending a message,
 * packet, or sound.
 *
 * @see PlayerSet
 */
public interface PlayerOps {
    /**
     * Sends a packet to all players associated with this {@link PlayerOps}.
     *
     * @param packet the packet to send
     */
    void sendPacket(class_2596<?> packet);

    /**
     * Sends a chat message to all players associated with this {@link PlayerOps}.
     *
     * @param message the chat message to send
     */
    void sendMessage(class_2561 message);

    /**
     * Displays a title to all players associated with this {@link PlayerOps}.
     *
     * @param title the title message to display
     * @param lengthTicks the amount of ticks this title should stay on screen for
     */
    default void showTitle(class_2561 title, int lengthTicks) {
        this.showTitle(title, 10, lengthTicks, 10);
    }

    /**
     * Displays a title to all players associated with this {@link PlayerOps}.
     *
     * @param title the title message to display
     * @param fadeInTicks the amount of ticks it should take for this title to fade in
     * @param stayTicks the amount of ticks this title should remain on screen for
     * @param fadeOutTicks the amount of ticks it should take for this title to fade out
     */
    void showTitle(class_2561 title, int fadeInTicks, int stayTicks, int fadeOutTicks);

    /**
     * Displays a title and subtitle to all players associated with this {@link PlayerOps}.
     *
     * @param title the title message to display
     * @param subtitle the subtitle message to display
     * @param fadeInTicks the amount of ticks it should take for this title to fade in
     * @param stayTicks the amount of ticks this title should remain on screen for
     * @param fadeOutTicks the amount of ticks it should take for this title to fade out
     */
    void showTitle(class_2561 title, class_2561 subtitle, int fadeInTicks, int stayTicks, int fadeOutTicks);

    /**
     * Sends a message to the action bar of all players associated with this {@link PlayerOps}.
     *
     * @param message the action bar message to send
     */
    void sendActionBar(class_2561 message);

    /**
     * Sends a message to the action bar of all players associated with this {@link PlayerOps}.
     *
     * @param message the action bar message to send
     * @param fadeInTicks the amount of ticks it should take for this message to fade in
     * @param stayTicks the amount of ticks this message should remain on screen for
     * @param fadeOutTicks the amount of ticks it should take for this message to fade out
     */
    void sendActionBar(class_2561 message, int fadeInTicks, int stayTicks, int fadeOutTicks);

    /**
     * Plays a sound to all players associated with this {@link PlayerOps}.
     *
     * @param sound the sound to play
     */
    void playSound(class_3414 sound);

    /**
     * Plays a sound to all players associated with this {@link PlayerOps}.
     *
     * @param sound the sound to play
     * @param category the sound category to associate this sound with
     * @param volume the volume of the sound to play (corresponds to how quickly the volume falls off with distance)
     * @param pitch the pitch of the sound being played
     */
    void playSound(class_3414 sound, class_3419 category, float volume, float pitch);

    /**
     * Adds a {@link class_1293} to all players associated with this {@link PlayerOps}.
     *
     * @param effect the status effect to add
     */
    void addStatusEffect(class_1293 effect);
}
