package xyz.nucleoid.plasmid.api.map.template.processor;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import xyz.nucleoid.map_templates.MapTemplate;

import java.util.Map;
import net.minecraft.class_10352;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_7923;

/**
 * Template processor that replaces blocks in a template with specified blocks.
 *
 * @param blocks a map of blocks to replace, where the key is the block to be replaced and the value is the new block
 *
 * @author Hugman
 */
public record ReplaceBlocksTemplateProcessor(Map<class_2248, class_2248> blocks) implements MapTemplateProcessor {
    public static final MapCodec<ReplaceBlocksTemplateProcessor> CODEC = Codec.unboundedMap(class_7923.field_41175.method_39673(), class_7923.field_41175.method_39673()).fieldOf("blocks").xmap(ReplaceBlocksTemplateProcessor::new, ReplaceBlocksTemplateProcessor::blocks);

    @Override
    public MapCodec<? extends MapTemplateProcessor> getCodec() {
        return CODEC;
    }

    @Override
    public void processTemplate(MapTemplate template, class_10352.class_10353 parameters) {
        template.getBounds().forEach(pos -> {
            var state = template.getBlockState(pos);
            var block = state.method_26204();
            class_2248 newBlock = null;
            for (var entry : this.blocks.entrySet()) {
                if (entry.getKey() == block) {
                    newBlock = entry.getValue();
                    break;
                }
            }
            if (newBlock != null) {
                class_2680 newState = newBlock.method_9564();
                for (class_2769 property : state.method_28501()) {
                    newState = newState.method_28498(property) ? newState.method_11657(property, state.method_11654(property)) : newState;
                }
                template.setBlockState(pos, newState);
            }
        });
    }
}
