package xyz.nucleoid.plasmid.api.util;

import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_7696;
import net.minecraft.class_7699;
import net.minecraft.class_7701;

public enum WoodType {
    OAK(Type.REGULAR, class_2246.field_10394, class_2246.field_10503, class_2246.field_10431, class_2246.field_10126, class_2246.field_10519, class_2246.field_10250, class_2246.field_10161, class_2246.field_10119, class_2246.field_10563, class_2246.field_10620, class_2246.field_10188, class_2246.field_10149, class_2246.field_10121, class_2246.field_10187, class_2246.field_40262, class_2246.field_40272, class_2246.field_10057, class_2246.field_10484, class_1802.field_8533, class_1802.field_38216),
    SPRUCE(Type.REGULAR, class_2246.field_10217, class_2246.field_9988, class_2246.field_10037, class_2246.field_10155, class_2246.field_10436, class_2246.field_10558, class_2246.field_9975, class_2246.field_10071, class_2246.field_10569, class_2246.field_10020, class_2246.field_10291, class_2246.field_10521, class_2246.field_10411, class_2246.field_10088, class_2246.field_40263, class_2246.field_40273, class_2246.field_10066, class_2246.field_10332, class_1802.field_8486, class_1802.field_38217),
    BIRCH(Type.REGULAR, class_2246.field_10575, class_2246.field_10539, class_2246.field_10511, class_2246.field_10307, class_2246.field_10366, class_2246.field_10204, class_2246.field_10148, class_2246.field_10257, class_2246.field_10408, class_2246.field_10299, class_2246.field_10513, class_2246.field_10352, class_2246.field_10231,  class_2246.field_10391, class_2246.field_40264, class_2246.field_40274, class_2246.field_10417, class_2246.field_10592, class_1802.field_8442, class_1802.field_38218),
    JUNGLE(Type.REGULAR, class_2246.field_10276, class_2246.field_10335, class_2246.field_10306, class_2246.field_10303, class_2246.field_10254, class_2246.field_10084, class_2246.field_10334, class_2246.field_10617, class_2246.field_10122, class_2246.field_10319, class_2246.field_10041, class_2246.field_10627, class_2246.field_10544,  class_2246.field_10587, class_2246.field_40266, class_2246.field_40278, class_2246.field_10553, class_2246.field_10026, class_1802.field_8730, class_1802.field_38212),
    ACACIA(Type.REGULAR, class_2246.field_10385, class_2246.field_10098, class_2246.field_10533, class_2246.field_9999, class_2246.field_10622, class_2246.field_10103, class_2246.field_10218, class_2246.field_10031, class_2246.field_10256, class_2246.field_10144, class_2246.field_10457, class_2246.field_10232, class_2246.field_10284,  class_2246.field_10401, class_2246.field_40265, class_2246.field_40275, class_2246.field_10278, class_2246.field_10397, class_1802.field_8094, class_1802.field_38213),
    DARK_OAK(Type.REGULAR, class_2246.field_10160, class_2246.field_10035, class_2246.field_10010, class_2246.field_10178, class_2246.field_10244, class_2246.field_10374, class_2246.field_10075, class_2246.field_10500, class_2246.field_10616, class_2246.field_10132, class_2246.field_10196, class_2246.field_10403, class_2246.field_10330, class_2246.field_10265, class_2246.field_40267, class_2246.field_40279, class_2246.field_10493, class_2246.field_10470, class_1802.field_8138, class_1802.field_38214),
    CHERRY(Type.REGULAR, class_2246.field_42727, class_2246.field_42731, class_2246.field_42729, class_2246.field_42733, class_2246.field_42732, class_2246.field_42730, class_2246.field_42751, class_2246.field_42746, class_2246.field_42744, class_2246.field_42747, class_2246.field_42745, class_2246.field_42748, class_2246.field_42735, class_2246.field_42736, class_2246.field_42738, class_2246.field_42739, class_2246.field_42743, class_2246.field_42737, class_1802.field_42706, class_1802.field_42707),
    MANGROVE(Type.REGULAR, class_2246.field_37544, class_2246.field_37551, class_2246.field_37545, class_2246.field_37549, class_2246.field_37548, class_2246.field_37550, class_2246.field_37577, class_2246.field_37564, class_2246.field_37561, class_2246.field_37565, class_2246.field_37563, class_2246.field_37566, class_2246.field_37554,  class_2246.field_37552, class_2246.field_40270, class_2246.field_40280, class_2246.field_37559, class_2246.field_37553, class_1802.field_37531, class_1802.field_38215),
    PALE_OAK(Type.REGULAR, class_2246.field_54712, class_2246.field_54714, class_2246.field_54715, class_2246.field_54734, class_2246.field_54716, class_2246.field_54713, class_2246.field_54735, class_2246.field_54727, class_2246.field_54726, class_2246.field_54728, class_2246.field_54730, class_2246.field_54729, class_2246.field_54718,  class_2246.field_54721, class_2246.field_54722, class_2246.field_54719, class_2246.field_54724, class_2246.field_54720, class_1802.field_54620, class_1802.field_54621),
    // Put here non-full wood-like types (aka with fallback blocks/items/etc.)
    CRIMSON(Type.NETHER, class_2246.field_22121, class_2246.field_10541, class_2246.field_22118, class_2246.field_22505, class_2246.field_22119, class_2246.field_22506, class_2246.field_22126, class_2246.field_22128, class_2246.field_22098, class_2246.field_22132, class_2246.field_22096, class_2246.field_22102, class_2246.field_22104,  class_2246.field_22106, class_2246.field_40268, class_2246.field_40281, class_2246.field_22100, class_2246.field_22130, class_1802.field_37531, class_1802.field_38215),
    WARPED(Type.NETHER, class_2246.field_22114, class_2246.field_22115, class_2246.field_22111, class_2246.field_22503, class_2246.field_22112, class_2246.field_22504, class_2246.field_22127, class_2246.field_22129, class_2246.field_22099, class_2246.field_22133, class_2246.field_22097, class_2246.field_22103, class_2246.field_22105,  class_2246.field_22107, class_2246.field_40269, class_2246.field_40282, class_2246.field_22101, class_2246.field_22131, class_1802.field_8442, class_1802.field_38218),

    BAMBOO(Type.BAMBOO, class_2246.field_10211, class_2246.field_10335, class_2246.field_41072, class_2246.field_40294, class_2246.field_41073, class_2246.field_40294, class_2246.field_40294, class_2246.field_40292, class_2246.field_40287, class_2246.field_40290, class_2246.field_40289, class_2246.field_40291, class_2246.field_40277,  class_2246.field_40261, class_2246.field_40271, class_2246.field_40283, class_2246.field_40286, class_2246.field_40284, class_1802.field_40224, class_1802.field_40225);

    private final class_2248 plant, leaves, log, wood, strippedLog, strippedWood, planks, slab, stairs, fence, fenceGate, door, sign, wallSign, hangingSign, wallHangingSign, button, pressurePlate;
    private final class_1792 boat, chestBoat;
    private final Type type;
    private final class_7699 requiredFeatures;

    WoodType(Type type,  class_2248 plant, class_2248 leaves, class_2248 log, class_2248 wood, class_2248 strippedLog, class_2248 strippedWood, class_2248 planks, class_2248 slab, class_2248 stairs,
             class_2248 fence, class_2248 fenceGate, class_2248 door, class_2248 sign, class_2248 wallSign, class_2248 hangingSign, class_2248 hangingWallSign, class_2248 button, class_2248 pressurePlate, class_1792 boat, class_1792 chestBoat, class_7696... requiredFeatures) {
        this.type = type;
        this.plant = plant;
        this.leaves = leaves;
        this.log = log;
        this.wood = wood;
        this.strippedLog = strippedLog;
        this.strippedWood = strippedWood;
        this.planks = planks;
        this.slab = slab;
        this.stairs = stairs;
        this.fence = fence;
        this.fenceGate = fenceGate;
        this.door = door;
        this.sign = sign;
        this.wallSign = wallSign;
        this.hangingSign = hangingSign;
        this.wallHangingSign = hangingWallSign;
        this.button = button;
        this.pressurePlate = pressurePlate;
        this.boat = boat;
        this.chestBoat = chestBoat;

        this.requiredFeatures = class_7701.field_40180.method_45390(requiredFeatures);
    }

    public static WoodType getType(class_2248 block) {
        for (var type : WoodType.values()) {
            if(type.contains(block)) {
                return type;
            }
        }
        return null;
    }

    public static WoodType getType(class_1792 item) {
        for (var type : WoodType.values()) {
            if(type.contains(item)) {
                return type;
            }
        }
        return null;
    }

    public boolean contains(class_2248 block) {
        return block == this.plant || (this.type.hasLeavesLike() && block == this.leaves) || block == this.log  || block == this.strippedLog || (this.type.hasWood && (block == this.wood || block == this.strippedWood)) || block == this.planks || block == this.slab || block == this.stairs || block == this.fence || block == this.fenceGate || block == this.door || block == this.sign || block == this.button || block == this.pressurePlate;
    }

    public boolean contains(class_1792 item) {
        if(item instanceof class_1747 blockItem) {
            return this.contains(blockItem.method_7711());
        }
        else {
            return this.type.hasBoats() && (item == this.boat || item == this.chestBoat);
        }
    }

    public boolean isEnabled(class_7699 enabledFeatures) {
        return this.getRequiredFeatures().method_45400(enabledFeatures);
    }

    public class_7699 getRequiredFeatures() {
        return this.requiredFeatures;
    }

    public Type type() {
        return this.type;
    }

    @Deprecated
    public class_2248 getSapling() {
        return this.plant;
    }

    public class_2248 getPlant() {
        return this.plant;
    }

    public class_2248 getLeaves() {
        return this.leaves;
    }

    public class_2248 getLog() {
        return this.log;
    }

    public class_2248 getPlanks() {
        return this.planks;
    }

    public class_2248 getSlab() {
        return this.slab;
    }

    public class_2248 getStairs() {
        return this.stairs;
    }

    public class_2248 getFence() {
        return this.fence;
    }

    public class_2248 getFenceGate() {
        return this.fenceGate;
    }

    public class_2248 getDoor() {
        return this.door;
    }

    public class_2248 getSign() {
        return this.sign;
    }
    public class_2248 getWallSign() {
        return this.wallSign;
    }

    public class_2248 getHangingSign() {
        return this.hangingSign;
    }
    public class_2248 getWallHangingSign() {
        return this.wallHangingSign;
    }

    public class_2248 getButton() {
        return this.button;
    }

    public class_2248 getPressurePlate() {
        return this.pressurePlate;
    }

    public class_1792 getBoat() {
        return this.boat;
    }

    public enum Type {
        REGULAR(true, true, true, true),
        NETHER(false, true, true, false),
        BAMBOO(true, false, false, false);

        final boolean hasBoats, hasWood, hasLeavesLike, hasLeaves;

        Type(boolean hasBoats, boolean hasWood, boolean hasLeaveLike, boolean hasLeaves) {
            this.hasBoats = hasBoats;
            this.hasWood = hasWood;
            this.hasLeavesLike = hasLeaveLike;
            this.hasLeaves = hasLeaves;
        }

        public boolean hasBoats() {
            return this.hasBoats;
        }

        public boolean hasWood() {
            return this.hasWood;
        }

        public boolean hasLeavesLike() {
            return this.hasLeavesLike;
        }

        public boolean hasLeaves() {
            return this.hasLeaves;
        }
    }
}
