package xyz.nucleoid.plasmid.client.mixin.game.space;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import net.minecraft.class_1130;
import net.minecraft.class_3222;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import xyz.nucleoid.plasmid.impl.game.manager.GameSpaceManagerImpl;

@Mixin(class_1130.class)
public abstract class IntegratedPlayerManagerMixin {

    @ModifyExpressionValue(
            method = "savePlayerData",
            at = @At(value = "INVOKE", target = "Lnet/minecraft/server/integrated/IntegratedServer;isHost(Lnet/minecraft/server/PlayerConfigEntry;)Z")
    )
    private boolean canSavePlayerData(boolean original, class_3222 player) {
        return original && !GameSpaceManagerImpl.get().inGame(player);
    }
}
