package xyz.nucleoid.plasmid.impl.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.minecraft.class_2168;
import net.minecraft.class_2179;
import xyz.nucleoid.plasmid.impl.command.argument.GameConfigArgument;

import static net.minecraft.class_2170.method_9244;
import static net.minecraft.class_2170.method_9247;

public final class GameTestCommand {
    // @formatter:off
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register(
            method_9247("game")
                .then(method_9247("test")
                    .requires(Permissions.require("plasmid.command.game.test", 2))
                    .then(GameConfigArgument.argument("game_config")
                        .executes(GameTestCommand::openTestGame)
                    )
                    .then(method_9244("game_config_nbt", class_2179.method_9284())
                        .executes(GameTestCommand::openAnonymousTestGame)
                    )
                )
        );
    }
    // @formatter:on

    private static int openTestGame(CommandContext<class_2168> context) throws CommandSyntaxException {
        return GameCommand.openGame(context, true);
    }

    private static int openAnonymousTestGame(CommandContext<class_2168> context) throws CommandSyntaxException {
        return GameCommand.openAnonymousGame(context, true);
    }
}
