package xyz.nucleoid.plasmid.impl.command;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.class_2168;
import net.minecraft.class_2196;
import net.minecraft.class_2556;
import xyz.nucleoid.plasmid.api.chat.ChatChannel;
import xyz.nucleoid.plasmid.api.chat.HasChatChannel;

import static net.minecraft.class_2170.method_9244;
import static net.minecraft.class_2170.method_9247;

public class ShoutCommand {
    // @formatter:off
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register(
            method_9247("shout")
                .then(method_9244("message", class_2196.method_9340())
                .executes(ShoutCommand::sendMessage))
        );
    }
    // @formatter:on

    public static int sendMessage(CommandContext<class_2168> context) throws CommandSyntaxException {
        var source = context.getSource();
        var server = source.method_9211();
        var hasChatChannel = (HasChatChannel) source.method_9207();
        class_2196.method_45562(context, "message", message -> {
            var old = hasChatChannel.getChatChannel();
            try {
                hasChatChannel.setChatChannel(ChatChannel.ALL);
                server.method_3760().method_44166(message, source, class_2556.method_44833(class_2556.field_11737, source));
            } finally {
                hasChatChannel.setChatChannel(old);
            }
        });

        return Command.SINGLE_SUCCESS;
    }
}
