package xyz.nucleoid.plasmid.impl.command.argument;

import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2232;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import xyz.nucleoid.plasmid.api.game.GameSpace;
import xyz.nucleoid.plasmid.impl.game.manager.GameSpaceManagerImpl;

public final class GameSpaceArgument {
    private static final SimpleCommandExceptionType GAME_NOT_FOUND = new SimpleCommandExceptionType(class_2561.method_43471("text.plasmid.game.not_found"));

    public static RequiredArgumentBuilder<class_2168, class_2960> argument(String name) {
        return class_2170.method_9244(name, class_2232.method_9441())
                .suggests((context, builder) -> {
                    var gameSpaceManager = GameSpaceManagerImpl.get();

                    return class_2172.method_9257(
                            gameSpaceManager.getOpenGameSpaces().stream().map(space -> space.getMetadata().userId()),
                            builder
                    );
                });
    }

    public static GameSpace get(CommandContext<class_2168> context, String name) throws CommandSyntaxException {
        var identifier = class_2232.method_9443(context, name);

        var gameSpace = GameSpaceManagerImpl.get().byUserId(identifier);
        if (gameSpace == null) {
            throw GAME_NOT_FOUND.create();
        }

        return gameSpace;
    }
}
