package xyz.nucleoid.plasmid.impl.compatibility;

import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.disguiselib.api.EntityDisguise;

public final class DisguiseLibCompatibility {
    private static final boolean ENABLED = FabricLoader.getInstance().isModLoaded("disguiselib");

    public static double getEntityHeight(class_1297 entity) {
        if (ENABLED) {
            return getDisguisedHeight(entity);
        } else {
            return entity.method_17682();
        }
    }

    private static double getDisguisedHeight(class_1297 entity) {
        var disguise = getDisguiseFor(entity);
        return disguise != null ? disguise.method_17682() : entity.method_17682();
    }

    @Nullable
    private static class_1297 getDisguiseFor(class_1297 entity) {
        if (entity instanceof EntityDisguise disguised && disguised.isDisguised()) {
            return disguised.getDisguiseEntity();
        } else {
            return null;
        }
    }
}
