package xyz.nucleoid.plasmid.impl.game.common.ui.element;

import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementInterface;
import xyz.nucleoid.plasmid.api.game.common.team.GameTeamKey;
import xyz.nucleoid.plasmid.api.game.common.team.GameTeamList;
import xyz.nucleoid.plasmid.api.game.common.ui.WaitingLobbyUiElement;
import xyz.nucleoid.plasmid.api.util.ColoredBlocks;

import java.util.ArrayList;
import java.util.SequencedCollection;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_124;
import net.minecraft.class_1802;
import net.minecraft.class_2561;

public class TeamSelectionWaitingLobbyUiElement implements WaitingLobbyUiElement {
    private final GameTeamList teams;

    private final Predicate<GameTeamKey> activePredicate;
    private final Consumer<GameTeamKey> selectCallback;

    public TeamSelectionWaitingLobbyUiElement(GameTeamList teams, Predicate<GameTeamKey> activePredicate, Consumer<GameTeamKey> selectCallback) {
        this.teams = teams;

        this.activePredicate = activePredicate;
        this.selectCallback = selectCallback;
    }

    @Override
    public GuiElementInterface createMainElement() {
        return new GuiElementBuilder(class_1802.field_8407)
                .setItemName(class_2561.method_43471("text.plasmid.team_selection.teams"))
                .build();
    }

    @Override
    public SequencedCollection<GuiElementInterface> createExtendedElements() {
        var extendedElements = new ArrayList<GuiElementInterface>(this.teams.list().size());

        for (var team : this.teams) {
            var key = team.key();
            var config = team.config();

            var name = class_2561.method_43469("text.plasmid.team_selection.request_team", config.name())
                    .method_27695(class_124.field_1067, config.chatFormatting());

            var element = new GuiElementBuilder(ColoredBlocks.wool(config.blockDyeColor()).method_8389())
                    .setItemName(name)
                    .setCallback((index, type, action, gui) -> {
                        if (WaitingLobbyUiElement.isClick(type, gui)) {
                            this.selectCallback.accept(key);
                        }
                    })
                    .glow(this.activePredicate.test(key))
                    .build();

            extendedElements.add(element);
        }

        return extendedElements;
    }
}
