package xyz.nucleoid.plasmid.impl.portal;

import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import xyz.nucleoid.plasmid.api.game.GameSpace;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;

public interface GamePortalBackend {
    default void populateDisplay(GamePortalDisplay display) {
        display.set(GamePortalDisplay.NAME, class_2561.method_43473().method_10852(this.getName()).method_27692(class_124.field_1075));
        display.set(GamePortalDisplay.PLAYER_COUNT, this.getPlayerCount());
        display.set(GamePortalDisplay.MAX_PLAYER_COUNT, this.getMaxPlayerCount());
        display.set(GamePortalDisplay.SPECTATOR_COUNT, this.getSpectatorCount());
    }

    void applyTo(class_3222 player, boolean alt);

    default class_2561 getName() {
        return class_2561.method_43470("༼ つ ◕_◕ ༽つ (Unnamed)");
    }

    default List<class_2561> getDescription() {
        return Collections.emptyList();
    }
    
    default class_1799 getIcon() {
        return new class_1799(class_1802.field_8270);
    }

    default int getPlayerCount() {
        return -1;
    }

    default int getMaxPlayerCount() {
        return -1;
    }

    default int getSpectatorCount() {
        return -1;
    }

    default ActionType getActionType() {
        return ActionType.NONE;
    }
    default ActionType getAltActionType() {
        return ActionType.NONE;
    }

    default void provideGameSpaces(Consumer<GameSpace> consumer) {}

    interface Factory {
        GamePortalBackend create(MinecraftServer server, class_2960 id);
    }

    record ActionType(class_2561 text, class_2561 textAlt) {
        public static ActionType NONE = new ActionType(class_2561.method_43473(), class_2561.method_43473());
        public static ActionType PLAY = new ActionType(class_2561.method_43471("text.plasmid.ui.game_join.action.play"), class_2561.method_43471("text.plasmid.ui.game_join.action.play.alt"));
        public static ActionType SPECTATE = new ActionType(class_2561.method_43471("text.plasmid.ui.game_join.action.spectate"), class_2561.method_43471("text.plasmid.ui.game_join.action.spectate.alt"));
    }
}
