package xyz.nucleoid.plasmid.impl.portal.game;

import net.minecraft.class_124;
import net.minecraft.class_3222;
import net.minecraft.class_6880;
import net.minecraft.server.MinecraftServer;
import xyz.nucleoid.plasmid.api.game.GameResult;
import xyz.nucleoid.plasmid.api.game.GameSpace;
import xyz.nucleoid.plasmid.api.game.config.GameConfig;
import xyz.nucleoid.plasmid.impl.game.manager.GameSpaceManagerImpl;
import xyz.nucleoid.plasmid.api.game.player.GamePlayerJoiner;
import xyz.nucleoid.plasmid.api.game.player.JoinIntent;

import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

public final class ConcurrentGamePortalBackend implements GameConfigGamePortalBackend {
    private final class_6880<GameConfig<?>> game;
    private CompletableFuture<GameSpace> gameFuture;

    public ConcurrentGamePortalBackend(class_6880<GameConfig<?>> game) {
        this.game = game;
    }

    @Override
    public class_6880<GameConfig<?>> game() {
        return this.game;
    }

    @Override
    public void applyTo(class_3222 player, boolean alt) {
        for (var gameSpace : GameSpaceManagerImpl.get().getOpenGameSpaces()) {
            if (gameSpace.getMetadata().sourceConfig().equals(this.game)) {
                var result = GamePlayerJoiner.tryJoin(player, gameSpace, alt ? JoinIntent.SPECTATE : JoinIntent.PLAY);

                if (result.isOk()) {
                    return;
                }
            }
        }

        CompletableFuture.supplyAsync(() -> this.getOrOpenNew(player.method_51469().method_8503()))
                .thenCompose(Function.identity())
                .handleAsync((gameSpace, throwable) -> {
                    this.gameFuture = null;
                    GameResult result;
                    if (gameSpace != null) {
                        result = GamePlayerJoiner.tryJoin(player, gameSpace, JoinIntent.PLAY);
                    } else {
                        result = GamePlayerJoiner.handleJoinException(throwable);
                    }

                    if (result.isError()) {
                        player.method_7353(result.errorCopy().method_27692(class_124.field_1061), false);
                    }

                    return null;
                }, player.method_51469().method_8503());
    }

    public CompletableFuture<GameSpace> getOrOpenNew(MinecraftServer server) {
        var future = this.gameFuture;
        if (future == null || future.isCompletedExceptionally()) {
            this.gameFuture = future = this.openGame(server);
        }
        return future;
    }

    private CompletableFuture<GameSpace> openGame(MinecraftServer server) {
        return GameSpaceManagerImpl.get().open(this.game);
    }
}
