package xyz.nucleoid.plasmid.impl.portal.game;

import xyz.nucleoid.plasmid.api.game.GameSpace;
import xyz.nucleoid.plasmid.api.game.config.GameConfig;
import xyz.nucleoid.plasmid.impl.game.manager.GameSpaceManagerImpl;
import xyz.nucleoid.plasmid.impl.portal.GamePortalBackend;

import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_6880;

public interface GameConfigGamePortalBackend extends GamePortalBackend {
    class_6880<GameConfig<?>> game();

    @Override
    default void provideGameSpaces(Consumer<GameSpace> consumer) {
        for (var gameSpace : GameSpaceManagerImpl.get().getOpenGameSpaces()) {
            if (gameSpace.getMetadata().isSourceConfig(this.game())) {
                consumer.accept(gameSpace);
            }
        }
    }

    @Override
    default int getPlayerCount() {
        int count = 0;
        for (var gameSpace : GameSpaceManagerImpl.get().getOpenGameSpaces()) {
            if (gameSpace.getMetadata().isSourceConfig(this.game())) {
                count += gameSpace.getState().players();
            }
        }
        return count;
    }

    @Override
    default int getSpectatorCount() {
        int count = 0;
        for (var gameSpace : GameSpaceManagerImpl.get().getOpenGameSpaces()) {
            if (gameSpace.getMetadata().isSourceConfig(this.game())) {
                count += gameSpace.getState().spectators();
            }
        }
        return count;
    }

    @Override
    default List<class_2561> getDescription() {
        return this.game().comp_349().description();
    }

    @Override
    default class_1799 getIcon() {
        return this.game().comp_349().icon();
    }

    @Override
    default class_2561 getName() {
        return GameConfig.name(this.game());
    }

    @Override
    default ActionType getActionType() {
        return ActionType.PLAY;
    }
}
