package xyz.nucleoid.plasmid.impl.portal.game;

import net.minecraft.class_124;
import net.minecraft.class_3222;
import net.minecraft.class_6880;
import net.minecraft.server.MinecraftServer;
import xyz.nucleoid.plasmid.api.game.GameResult;
import xyz.nucleoid.plasmid.api.game.GameSpace;
import xyz.nucleoid.plasmid.api.game.config.GameConfig;
import xyz.nucleoid.plasmid.impl.game.manager.GameSpaceManagerImpl;
import xyz.nucleoid.plasmid.api.game.player.GamePlayerJoiner;
import xyz.nucleoid.plasmid.api.game.player.JoinIntent;

import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

public record NewGamePortalBackend(class_6880<GameConfig<?>> game) implements GameConfigGamePortalBackend {
    @Override
    public void applyTo(class_3222 player, boolean alt) {
        CompletableFuture.supplyAsync(() -> this.openGame(player.method_51469().method_8503()))
                .thenCompose(Function.identity())
                .handleAsync((gameSpace, throwable) -> {
                    GameResult result;
                    if (gameSpace != null) {
                        result = GamePlayerJoiner.tryJoin(player, gameSpace, JoinIntent.PLAY);
                    } else {
                        result = GamePlayerJoiner.handleJoinException(throwable);
                    }

                    if (result.isError()) {
                        player.method_7353(result.errorCopy().method_27692(class_124.field_1061), false);
                    }

                    return null;
                }, player.method_51469().method_8503());
    }

    private CompletableFuture<GameSpace> openGame(MinecraftServer server) {
        return GameSpaceManagerImpl.get().open(this.game);
    }
}
