package xyz.nucleoid.plasmid.impl.portal.menu;

import eu.pb4.sgui.api.elements.GuiElementInterface;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import xyz.nucleoid.plasmid.api.game.GameSpace;
import xyz.nucleoid.plasmid.impl.portal.GamePortalBackend;
import xyz.nucleoid.plasmid.api.util.Guis;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public final class AdvancedMenuPortalBackend implements GamePortalBackend {
    private final class_2561 name;

    private final List<class_2561> description;
    private final class_1799 icon;

    private final List<MenuEntryConfig> entryConfigs;
    private List<MenuEntry> entries;

    AdvancedMenuPortalBackend(class_2561 name, List<class_2561> description, class_1799 icon, List<MenuEntryConfig> entryConfigs) {
        this.name = name;

        this.description = description;
        this.icon = icon;

        this.entryConfigs = entryConfigs;
    }

    @Override
    public class_2561 getName() {
        return this.name;
    }

    @Override
    public List<class_2561> getDescription() {
        return this.description;
    }

    @Override
    public class_1799 getIcon() {
        return this.icon;
    }

    @Override
    public int getPlayerCount() {
        int count = 0;
        var uniqueGameSpaces = new ReferenceOpenHashSet<GameSpace>();
        provideGameSpaces(uniqueGameSpaces::add);
        for (var entry : uniqueGameSpaces) {
            count += Math.max(0, entry.getState().players());
        }
        return count;
    }

    @Override
    public int getSpectatorCount() {
        int count = 0;
        var uniqueGameSpaces = new ReferenceOpenHashSet<GameSpace>();
        provideGameSpaces(uniqueGameSpaces::add);
        for (var entry : uniqueGameSpaces) {
            count += Math.max(0, entry.getState().spectators());
        }
        return count;
    }

    @Override
    public void provideGameSpaces(Consumer<GameSpace> consumer) {
        for (var entry : this.getEntries()) {
            entry.provideGameSpaces(consumer);
        }
    }

    private List<GuiElementInterface> getGuiElements() {
        List<GuiElementInterface> elements = new ArrayList<>();

        for (var entry : this.getEntries()) {
            var uiEntry = entry.createGuiElement();
            elements.add(uiEntry);
        }

        return elements;
    }

    private List<MenuEntry> getEntries() {
        if (this.entries == null) {
            this.entries = new ArrayList<MenuEntry>(this.entryConfigs.size());
            for (var configEntry : this.entryConfigs) {
                this.entries.add(configEntry.createEntry());
            }
        }

        return this.entries;
    }

    @Override
    public void applyTo(class_3222 player, boolean alt) {
        var ui = Guis.createSelectorGui(player, this.name.method_27661(), true, this.getGuiElements());
        ui.open();
    }
}
