package xyz.nucleoid.plasmid.impl.portal.menu;

import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import xyz.nucleoid.codecs.MoreCodecs;
import xyz.nucleoid.plasmid.api.game.config.GameConfig;
import xyz.nucleoid.plasmid.impl.portal.game.ConcurrentGamePortalBackend;
import xyz.nucleoid.plasmid.api.util.PlasmidCodecs;

import java.util.List;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_6880;

public record GameMenuEntryConfig(
        class_6880<GameConfig<?>> game,
        Optional<class_2561> name,
        Optional<List<class_2561>> description,
        Optional<class_1799> icon
) implements MenuEntryConfig {
    public static final MapCodec<GameMenuEntryConfig> CODEC = RecordCodecBuilder.mapCodec(i -> i.group(
            GameConfig.ENTRY_CODEC.fieldOf("game").forGetter(GameMenuEntryConfig::game),
            PlasmidCodecs.TEXT.optionalFieldOf("name").forGetter(GameMenuEntryConfig::name),
            MoreCodecs.listOrUnit(PlasmidCodecs.TEXT).optionalFieldOf("description").forGetter(GameMenuEntryConfig::description),
            MoreCodecs.ITEM_STACK.optionalFieldOf("icon").forGetter(GameMenuEntryConfig::icon)
    ).apply(i, GameMenuEntryConfig::new));

    @Override
    public MenuEntry createEntry() {
        var game = new ConcurrentGamePortalBackend(this.game);
        return new GameMenuEntry(
                game,
                this.name.orElse(GameConfig.name(this.game)),
                this.description.orElse(this.game.comp_349().description()),
                this.icon.orElse(this.game.comp_349().icon())
        );
    }

    @Override
    public MapCodec<GameMenuEntryConfig> codec() {
        return CODEC;
    }
}
