package xyz.nucleoid.plasmid.impl.portal.menu;

import eu.pb4.sgui.api.elements.GuiElement;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.plasmid.impl.portal.GamePortalBackend;
import xyz.nucleoid.plasmid.api.game.GameSpace;

import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import net.minecraft.class_5244;

public interface MenuEntry {
    class_2561 name();

    List<class_2561> description();

    class_1799 icon();

    void click(class_3222 player, boolean alt);

    default int getPlayerCount() {
        return -1;
    }

    default int getSpectatorCount() {
        return -1;
    }

    default int getMaxPlayerCount() {
        return -1;
    }

    @Nullable
    default class_2561 getState() {
        return null;
    }

    default boolean isHidden() {
        return false;
    }

    default GamePortalBackend.ActionType getActionType() {
        return GamePortalBackend.ActionType.NONE;
    }

    default GamePortalBackend.ActionType getAltActionType() {
        return GamePortalBackend.ActionType.NONE;
    }


    default void provideGameSpaces(Consumer<GameSpace> consumer) {

    }

    default GuiElement createGuiElement() {
        var element = GuiElementBuilder.from(this.icon().method_7972()).hideDefaultTooltip()
                .setName(class_2561.method_43473().method_10852(this.name()));

        for (var line : this.description()) {
            var text = line.method_27661();

            if (line.method_10866().method_10973() == null) {
                text.method_10862(line.method_10866().method_27706(class_124.field_1080));
            }

            element.addLoreLine(text);
        }

        var playerCount = this.getPlayerCount();
        var maxPlayerCount = this.getMaxPlayerCount();
        var spectatorCount = this.getSpectatorCount();
        boolean allowSpace = true;

        var state = this.getState();
        if (state != null) {
            element.addLoreLine(class_5244.field_39003);
            element.addLoreLine(class_2561.method_43470(" ").method_10852(state).method_27692(class_124.field_1068));
            allowSpace = false;
        }

        if (playerCount > -1) {
            if (allowSpace) {
                element.addLoreLine(class_5244.field_39003);
                allowSpace = false;
            }
            element.addLoreLine(class_2561.method_43473()
                    .method_10852(class_2561.method_43470("» ").method_27692(class_124.field_1063))
                    .method_10852(class_2561.method_43469("text.plasmid.ui.game_join.players",
                            class_2561.method_43470(playerCount + (maxPlayerCount > 0 ? " / " + maxPlayerCount : "")).method_27692(class_124.field_1054)).method_27692(class_124.field_1065))
            );
        }

        if (spectatorCount > 0) {
            if (allowSpace) {
                element.addLoreLine(class_5244.field_39003);
                allowSpace = false;
            }

            element.addLoreLine(class_2561.method_43473()
                    .method_10852(class_2561.method_43470("» ").method_27692(class_124.field_1063))
                    .method_10852(class_2561.method_43469("text.plasmid.ui.game_join.spectators",
                            class_2561.method_43470( spectatorCount + "").method_27692(class_124.field_1054)).method_27692(class_124.field_1065))
            );
        }

        var actionType = this.getActionType();

        if (actionType != GamePortalBackend.ActionType.NONE) {
            element.addLoreLine(class_2561.method_43473().method_10852(class_2561.method_43470(" [ ").method_27692(class_124.field_1080))
                    .method_10852(actionType.text())
                    .method_10852(class_2561.method_43470(" ]").method_27692(class_124.field_1080)).method_10862(class_2583.field_24360.method_36139(0x76ed6f)));
        }

        var altActionType = this.getAltActionType();

        if (altActionType != GamePortalBackend.ActionType.NONE) {
            element.addLoreLine(class_2561.method_43473().method_10852(class_2561.method_43470(" [ ").method_27692(class_124.field_1080))
                    .method_10852(actionType.text())
                    .method_10852(class_2561.method_43470(" ]").method_27692(class_124.field_1080)).method_10862(class_2583.field_24360.method_36139(0x76ed6f)));
        }

        element.setCallback((a, b, c, gui) -> {
            this.click(gui.getPlayer(), b.shift);
        });

        return element.build();
    }
}