package xyz.nucleoid.plasmid.impl.portal.menu;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import xyz.nucleoid.plasmid.api.game.config.GameConfig;
import xyz.nucleoid.plasmid.api.portal.menu.MenuEntryConfigs;
import xyz.nucleoid.plasmid.api.registry.PlasmidRegistries;
import xyz.nucleoid.plasmid.api.util.TinyRegistry;

import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_2960;

public interface MenuEntryConfig {
    /**
     * @deprecated Use {@link PlasmidRegistries#MENU_ENTRY} instead.
     */
    @Deprecated
    TinyRegistry<MapCodec<? extends MenuEntryConfig>> REGISTRY = new TinyRegistry.Fake<>(PlasmidRegistries.MENU_ENTRY);

    Codec<MenuEntryConfig> CODEC_OBJECT = PlasmidRegistries.MENU_ENTRY.method_39673().dispatchStable(MenuEntryConfig::codec, Function.identity());
    Codec<MenuEntryConfig> CODEC = Codec.either(GameConfig.ENTRY_CODEC, CODEC_OBJECT).xmap(either -> {
        return either.map((game) -> new GameMenuEntryConfig(game, Optional.empty(), Optional.empty(), Optional.empty()), Function.identity());
    }, Either::right);

    /**
     * @deprecated Use {@link MenuEntryConfigs#register(class_2960, MapCodec)} instead.
     */
    @Deprecated
    static MapCodec<? extends MenuEntryConfig> register(class_2960 key, MapCodec<? extends MenuEntryConfig> codec) {
        return MenuEntryConfigs.register(key, codec);
    }

    MenuEntry createEntry();

    MapCodec<? extends MenuEntryConfig> codec();
}
