package xyz.nucleoid.plasmid.impl.portal.menu;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5244;
import net.minecraft.class_6880;
import net.minecraft.server.MinecraftServer;
import xyz.nucleoid.codecs.MoreCodecs;
import xyz.nucleoid.plasmid.api.game.config.CustomValuesConfig;
import xyz.nucleoid.plasmid.api.game.config.GameConfig;
import xyz.nucleoid.plasmid.impl.portal.GamePortalBackend;
import xyz.nucleoid.plasmid.impl.portal.GamePortalConfig;
import xyz.nucleoid.plasmid.api.util.PlasmidCodecs;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;

public record MenuPortalConfig(
        class_2561 name,
        List<class_2561> description,
        class_1799 icon,
        List<Entry> games,
        CustomValuesConfig custom
) implements GamePortalConfig {

    public static final MapCodec<MenuPortalConfig> CODEC = RecordCodecBuilder.mapCodec(i -> i.group(
            PlasmidCodecs.TEXT.optionalFieldOf("name", class_5244.field_39003).forGetter(MenuPortalConfig::name),
            MoreCodecs.listOrUnit(PlasmidCodecs.TEXT).optionalFieldOf("description", Collections.emptyList()).forGetter(MenuPortalConfig::description),
            MoreCodecs.ITEM_STACK.optionalFieldOf("icon", new class_1799(class_1802.field_8270)).forGetter(MenuPortalConfig::icon),
            Entry.CODEC.listOf().fieldOf("games").forGetter(config -> config.games),
            CustomValuesConfig.CODEC.optionalFieldOf("custom", CustomValuesConfig.empty()).forGetter(config -> config.custom)
    ).apply(i, MenuPortalConfig::new));

    @Override
    public GamePortalBackend createBackend(MinecraftServer server, class_2960 id) {
        class_2561 name;
        if (this.name != null && this.name != class_5244.field_39003) {
            name = this.name;
        } else {
            name = class_2561.method_43470(id.toString());
        }

        return new MenuPortalBackend(name, this.description, this.icon, this.games);
    }

    @Override
    public MapCodec<MenuPortalConfig> codec() {
        return CODEC;
    }

    public record Entry(class_6880<GameConfig<?>> game,
                        Optional<class_2561> name,
                        Optional<List<class_2561>> description,
                        Optional<class_1799> icon) {

        static final Codec<Entry> CODEC_OBJECT = RecordCodecBuilder.create(i -> i.group(
                GameConfig.ENTRY_CODEC.fieldOf("game").forGetter(entry -> entry.game),
                PlasmidCodecs.TEXT.optionalFieldOf("name").forGetter(Entry::name),
                MoreCodecs.listOrUnit(PlasmidCodecs.TEXT).optionalFieldOf("description").forGetter(Entry::description),
                MoreCodecs.ITEM_STACK.optionalFieldOf("icon").forGetter(Entry::icon)
        ).apply(i, Entry::new));

        public static final Codec<Entry> CODEC = Codec.either(GameConfig.ENTRY_CODEC, CODEC_OBJECT)
                .xmap(either -> either.map((game) -> new Entry(game, Optional.empty(), Optional.empty(), Optional.empty()), Function.identity()), Either::right);
    }
}
