package xyz.nucleoid.plasmid.impl.portal.menu;

import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import xyz.nucleoid.plasmid.impl.portal.GamePortalBackend;
import xyz.nucleoid.plasmid.api.game.GameSpace;
import xyz.nucleoid.plasmid.impl.portal.GamePortal;

public record PortalEntry(
        GamePortal portal,
        class_2561 name,
        List<class_2561> description,
        class_1799 icon
) implements MenuEntry {
    public PortalEntry(GamePortal portal) {
        this(portal, portal.getName(), portal.getDescription(), portal.getIcon());
    }

    @Override
    public void click(class_3222 player, boolean alt) {
        this.portal.requestJoin(player, alt);
    }

    @Override
    public int getPlayerCount() {
        return this.portal.getPlayerCount();
    }

    @Override
    public int getSpectatorCount() {
        return this.portal.getSpectatorCount();
    }

    @Override
    public int getMaxPlayerCount() {
        return this.portal.getMaxPlayerCount();
    }

    @Override
    public void provideGameSpaces(Consumer<GameSpace> consumer) {
        portal.provideGameSpaces(consumer);
    }

    @Override
    public GamePortalBackend.ActionType getActionType() {
        return this.portal.getBackend().getActionType();
    }

    @Override
    public GamePortalBackend.ActionType getAltActionType() {
        return this.portal.getBackend().getAltActionType();
    }
}