package xyz.nucleoid.plasmid.mixin.game.portal;

import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2625;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5244;
import net.minecraft.class_8242;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import xyz.nucleoid.plasmid.impl.portal.GamePortal;
import xyz.nucleoid.plasmid.impl.portal.GamePortalDisplay;
import xyz.nucleoid.plasmid.impl.portal.GamePortalInterface;

@Mixin(class_2625.class)
public abstract class SignBlockEntityMixin extends class_2586 implements GamePortalInterface {
    @Shadow
    public abstract class_8242 getText(boolean front);

    @Shadow
    public abstract boolean setText(class_8242 text, boolean front);

    @Shadow
    public abstract boolean isWaxed();

    @Shadow
    public abstract boolean setWaxed(boolean waxed);

    private SignBlockEntityMixin(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    @Unique
    private GamePortal portal;
    @Unique
    private class_2960 loadedPortalId;

    @Override
    public void setPortal(GamePortal portal) {
        this.portal = portal;
    }

    @Nullable
    @Override
    public GamePortal getPortal() {
        return this.portal;
    }

    @Override
    public void setDisplay(GamePortalDisplay display) {
        var lines = new class_2561[class_8242.field_43299];
        for (int i = 0; i < class_8242.field_43299; i++) {
            lines[i] = this.getDisplayLine(display, i);
        }

        var oldText = this.getText(true);
        this.setText(new class_8242(lines, lines, oldText.method_49872(), oldText.method_49856()), true);

        this.setWaxed(true);

        if (this.method_11002()) {
            class_2680 cachedState = this.method_11010();
            this.field_11863.method_8413(this.field_11867, cachedState, cachedState, class_2248.field_31036);
        }
    }

    @NotNull
    private class_2561 getDisplayLine(GamePortalDisplay display, int line) {
        if (line == 1) {
            var name = display.get(GamePortalDisplay.NAME);
            if (name != null) {
                return name;
            }
        } else if (line == 2) {
            var playerCount = display.get(GamePortalDisplay.PLAYER_COUNT);
            if (playerCount != null) {
                return class_2561.method_43469("text.plasmid.game.portal.player_count", playerCount);
            }
        }
        return class_5244.field_39003;
    }

    @Inject(method = "canRunCommandClickEvent", at = @At("HEAD"), cancellable = true)
    private void canRunCommandClickEvent(CallbackInfoReturnable<Boolean> ci) {
        if (this.isWaxed() && this.portal != null) {
            ci.setReturnValue(true);
        }
    }

    @Inject(method = "runCommandClickEvent", at = @At("HEAD"), cancellable = true)
    private void runCommandClickEvent(class_3218 world, class_1657 player, class_2338 pos, boolean front, CallbackInfoReturnable<Boolean> ci) {
        if (this.portal != null && player instanceof class_3222 serverPlayer) {
            this.portal.requestJoin(serverPlayer, false);
            ci.setReturnValue(true);
        }
    }

    @Inject(method = "writeData", at = @At("RETURN"))
    private void writePortalNbt(class_11372 view, CallbackInfo ci) {
        this.serializePortal(view);
    }

    @Inject(method = "readData", at = @At("RETURN"))
    private void readPortalData(class_11368 view, CallbackInfo ci) {
        this.loadedPortalId = this.deserializePortalId(view);
    }

    @Override
    public void method_31662(class_1937 world) {
        super.method_31662(world);

        var server = world.method_8503();
        if (server != null && this.loadedPortalId != null) {
            this.tryConnectTo(this.loadedPortalId);
            this.loadedPortalId = null;
        }
    }

    @Override
    public boolean updatePortalImmediately() {
        return this.loadedPortalId == null;
    }

    @Override
    public void method_11012() {
        super.method_11012();
        this.invalidatePortal();
    }
}
