package xyz.nucleoid.plasmid.mixin.game.rule;

import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import com.llamalad7.mixinextras.sugar.Local;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_3222;
import net.minecraft.class_47;
import net.minecraft.class_52;
import net.minecraft.class_5819;
import xyz.nucleoid.plasmid.api.game.rule.GameRuleType;
import xyz.nucleoid.plasmid.impl.game.manager.GameSpaceManagerImpl;
import xyz.nucleoid.stimuli.event.EventResult;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(class_52.class)
public class LootTableMixin {
    @WrapWithCondition(
            method = "supplyInventory",
            at = @At(value = "INVOKE", target = "Lnet/minecraft/loot/LootTable;spreadStacks(Lit/unimi/dsi/fastutil/objects/ObjectArrayList;ILnet/minecraft/util/math/random/Random;)V")
    )
    public boolean preventContainerLootShuffling(class_52 lootTable, ObjectArrayList<class_1799> stacks, int freeSlots, class_5819 random, @Local class_47 context) {
        var entity = context.method_65013(class_181.field_1226);
        var gameSpace = entity instanceof class_3222 player ? GameSpaceManagerImpl.get().byPlayer(player) : GameSpaceManagerImpl.get().byWorld(context.method_299());

        if (gameSpace != null && gameSpace.getBehavior().testRule(GameRuleType.SPREAD_CONTAINER_LOOT) == EventResult.DENY) {
            return false;
        }

        return true;
    }
}
