package xyz.nucleoid.plasmid.mixin.game.rule;

import net.minecraft.class_1299;
import net.minecraft.class_1665;
import net.minecraft.class_1685;
import net.minecraft.class_1937;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import xyz.nucleoid.plasmid.impl.game.manager.GameSpaceManagerImpl;
import xyz.nucleoid.plasmid.api.game.rule.GameRuleType;
import xyz.nucleoid.stimuli.event.EventResult;

@Mixin(class_1685.class)
public abstract class TridentEntityMixin extends class_1665 {
    @Shadow
    private boolean dealtDamage;

    protected TridentEntityMixin(class_1299<? extends class_1665> type, class_1937 world) {
        super(type, world);
    }

    @Inject(method = "tick", at = @At("HEAD"))
    private void tick(CallbackInfo ci) {
        if (!this.dealtDamage && this.method_23318() <= this.method_73183().method_31607() && !this.method_73183().method_8608()) {
            var gameSpace = GameSpaceManagerImpl.get().byWorld(this.method_73183());
            if (gameSpace != null && gameSpace.getBehavior().testRule(GameRuleType.TRIDENTS_LOYAL_IN_VOID) == EventResult.ALLOW) {
                this.dealtDamage = true;
                this.method_18800(0.0, 0.0, 0.0);
            }
        }
    }
}
