/*
 * Decompiled with CFR 0.152.
 */
package xyz.nucleoid.plasmid.api.event;

import java.util.Set;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_3222;
import net.minecraft.class_6880;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.plasmid.api.game.GameActivity;
import xyz.nucleoid.plasmid.api.game.GameCloseReason;
import xyz.nucleoid.plasmid.api.game.GameResult;
import xyz.nucleoid.plasmid.api.game.GameSpace;
import xyz.nucleoid.plasmid.api.game.common.team.GameTeamKey;
import xyz.nucleoid.plasmid.api.game.common.team.TeamAllocator;
import xyz.nucleoid.plasmid.api.game.config.GameConfig;
import xyz.nucleoid.plasmid.api.game.player.PlayerIterable;

public final class GameEvents {
    public static final Event<GameSpaceOpened> OPENED = EventFactory.createArrayBacked(GameSpaceOpened.class, listeners -> (game, gameSpace) -> {
        for (GameSpaceOpened listener : listeners) {
            listener.onGameSpaceOpened(game, gameSpace);
        }
    });
    public static final Event<CreateActivity> CREATE_ACTIVITY = EventFactory.createArrayBacked(CreateActivity.class, listeners -> (gameSpace, activity) -> {
        for (CreateActivity listener : listeners) {
            listener.onCreateActivity(gameSpace, activity);
        }
    });
    public static final Event<DestroyActivity> DESTROY_ACTIVITY = EventFactory.createArrayBacked(DestroyActivity.class, listeners -> (gameSpace, activity, reason) -> {
        for (DestroyActivity listener : listeners) {
            listener.onDestroyActivity(gameSpace, activity, reason);
        }
    });
    public static final Event<RequestStart> START_REQUEST = EventFactory.createArrayBacked(RequestStart.class, listeners -> (gameSpace, result) -> {
        for (RequestStart listener : listeners) {
            GameResult tmp = listener.onRequestStart(gameSpace, result);
            if (tmp == null) continue;
            result = tmp;
        }
        return result;
    });
    public static final Event<GameSpaceClosing> CLOSING = EventFactory.createArrayBacked(GameSpaceClosing.class, listeners -> (gameSpace, reason) -> {
        for (GameSpaceClosing listener : listeners) {
            listener.onGameSpaceClosing(gameSpace, reason);
        }
    });
    public static final Event<CollectPlayersForJoin> COLLECT_PLAYERS_FOR_JOIN = EventFactory.createArrayBacked(CollectPlayersForJoin.class, listeners -> (gameSpace, player, additional) -> {
        for (CollectPlayersForJoin listener : listeners) {
            listener.collectPlayersForJoin(gameSpace, player, additional);
        }
    });
    public static final Event<PlayerJoin> PLAYER_JOIN = EventFactory.createArrayBacked(PlayerJoin.class, listeners -> (gameSpace, player) -> {
        for (PlayerJoin listener : listeners) {
            listener.onPlayerJoin(gameSpace, player);
        }
    });
    public static final Event<PlayerLeft> PLAYER_LEFT = EventFactory.createArrayBacked(PlayerLeft.class, listeners -> (gameSpace, player) -> {
        for (PlayerLeft listener : listeners) {
            listener.onPlayerLeft(gameSpace, player);
        }
    });
    @ApiStatus.Experimental
    public static final Event<TeamSelectionLobbyFinalize> TEAM_SELECTION_LOBBY_FINALIZE = EventFactory.createArrayBacked(TeamSelectionLobbyFinalize.class, listeners -> (gameSpace, allocator, players) -> {
        for (TeamSelectionLobbyFinalize listener : listeners) {
            listener.onFinalizeTeamSelection(gameSpace, allocator, players);
        }
    });

    private GameEvents() {
    }

    @ApiStatus.Experimental
    public static interface TeamSelectionLobbyFinalize {
        public void onFinalizeTeamSelection(GameSpace var1, TeamAllocator<GameTeamKey, class_3222> var2, PlayerIterable var3);
    }

    public static interface PlayerLeft {
        public void onPlayerLeft(GameSpace var1, class_3222 var2);
    }

    public static interface PlayerJoin {
        public void onPlayerJoin(GameSpace var1, class_3222 var2);
    }

    public static interface CollectPlayersForJoin {
        public void collectPlayersForJoin(GameSpace var1, class_3222 var2, Set<class_3222> var3);
    }

    public static interface GameSpaceClosing {
        public void onGameSpaceClosing(GameSpace var1, GameCloseReason var2);
    }

    public static interface RequestStart {
        @Nullable
        public GameResult onRequestStart(GameSpace var1, @Nullable GameResult var2);
    }

    public static interface DestroyActivity {
        public void onDestroyActivity(GameSpace var1, GameActivity var2, GameCloseReason var3);
    }

    public static interface CreateActivity {
        public void onCreateActivity(GameSpace var1, GameActivity var2);
    }

    public static interface GameSpaceOpened {
        public void onGameSpaceOpened(class_6880<GameConfig<?>> var1, GameSpace var2);
    }
}

