/*
 * Decompiled with CFR 0.152.
 */
package xyz.nucleoid.plasmid.api.game;

import java.util.ArrayList;
import java.util.List;
import xyz.nucleoid.plasmid.impl.Plasmid;

public final class GameResources
implements AutoCloseable {
    private final List<AutoCloseable> resources = new ArrayList<AutoCloseable>();

    public synchronized <T extends AutoCloseable> T add(T resource) {
        this.resources.add(resource);
        return resource;
    }

    @Override
    public synchronized void close() {
        for (AutoCloseable resource : this.resources) {
            try {
                resource.close();
            }
            catch (Exception e) {
                Plasmid.LOGGER.warn("Failed to close resource for game", (Throwable)e);
            }
        }
        this.resources.clear();
    }
}

