/*
 * Decompiled with CFR 0.152.
 */
package xyz.nucleoid.plasmid.api.game.common;

import eu.pb4.polymer.core.api.utils.PolymerUtils;
import eu.pb4.sgui.api.GuiHelpers;
import eu.pb4.sgui.api.gui.GuiInterface;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1259;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_6880;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.plasmid.api.game.GameActivity;
import xyz.nucleoid.plasmid.api.game.GameResult;
import xyz.nucleoid.plasmid.api.game.GameSpace;
import xyz.nucleoid.plasmid.api.game.GameSpacePlayers;
import xyz.nucleoid.plasmid.api.game.GameSpaceState;
import xyz.nucleoid.plasmid.api.game.GameTexts;
import xyz.nucleoid.plasmid.api.game.common.GlobalWidgets;
import xyz.nucleoid.plasmid.api.game.common.PlayerLimiter;
import xyz.nucleoid.plasmid.api.game.common.config.WaitingLobbyConfig;
import xyz.nucleoid.plasmid.api.game.common.ui.WaitingLobbyUiLayout;
import xyz.nucleoid.plasmid.api.game.common.widget.BossBarWidget;
import xyz.nucleoid.plasmid.api.game.common.widget.SidebarWidget;
import xyz.nucleoid.plasmid.api.game.config.GameConfig;
import xyz.nucleoid.plasmid.api.game.event.GameActivityEvents;
import xyz.nucleoid.plasmid.api.game.event.GamePlayerEvents;
import xyz.nucleoid.plasmid.api.game.event.GameWaitingLobbyEvents;
import xyz.nucleoid.plasmid.api.game.player.JoinOffer;
import xyz.nucleoid.plasmid.api.game.player.JoinOfferResult;
import xyz.nucleoid.plasmid.api.game.rule.GameRuleType;
import xyz.nucleoid.plasmid.impl.compatibility.AfkDisplayCompatibility;
import xyz.nucleoid.plasmid.impl.game.common.ui.WaitingLobbyUi;
import xyz.nucleoid.plasmid.impl.game.common.ui.element.LeaveGameWaitingLobbyUiElement;
import xyz.nucleoid.plasmid.impl.game.manager.GameSpaceManagerImpl;

public final class GameWaitingLobby {
    private static final class_2561 WAITING_TITLE = class_2561.method_43471((String)"text.plasmid.game.waiting_lobby.bar.waiting");
    private static final int START_REQUESTED_COUNTDOWN = 60;
    private static final class_1259.class_1260 WAITING_COLOR = class_1259.class_1260.field_5780;
    private static final class_1259.class_1260 COUNTING_COLOR = class_1259.class_1260.field_5785;
    private static final class_1259.class_1261 BOSS_BAR_STYLE = class_1259.class_1261.field_5791;
    private static final class_2561 PADDING_LINE = class_2561.method_43470((String)" ".repeat(36));
    private final GameSpace gameSpace;
    private final WaitingLobbyConfig playerConfig;
    private final PlayerLimiter limiter;
    private final BossBarWidget bar;
    private final SidebarWidget sidebar;
    private long countdownStart = -1L;
    private long countdownDuration = -1L;
    private boolean startRequested;
    private boolean started;
    private List<class_2561> sidebarText;

    private GameWaitingLobby(GameSpace gameSpace, WaitingLobbyConfig playerConfig, BossBarWidget bar, SidebarWidget sidebar, PlayerLimiter limiter) {
        this.gameSpace = gameSpace;
        this.playerConfig = playerConfig;
        this.bar = bar;
        this.sidebar = sidebar;
        this.limiter = limiter;
    }

    public static GameWaitingLobby addTo(GameActivity activity, WaitingLobbyConfig playerConfig) {
        class_6880<GameConfig<?>> sourceConfig = activity.getGameSpace().getMetadata().sourceConfig();
        GlobalWidgets widgets = GlobalWidgets.addTo(activity);
        BossBarWidget bar = widgets.addBossBar(WAITING_TITLE, WAITING_COLOR, BOSS_BAR_STYLE);
        SidebarWidget sidebar = widgets.addSidebar();
        PlayerLimiter limiter = PlayerLimiter.addTo(activity, playerConfig.playerConfig());
        GameWaitingLobby lobby = new GameWaitingLobby(activity.getGameSpace(), playerConfig, bar, sidebar, limiter);
        activity.deny(GameRuleType.PVP).deny(GameRuleType.FALL_DAMAGE).deny(GameRuleType.HUNGER).deny(GameRuleType.CRAFTING).deny(GameRuleType.PORTALS).deny(GameRuleType.THROW_ITEMS).deny(GameRuleType.INTERACTION).deny(GameRuleType.PLACE_BLOCKS).deny(GameRuleType.BREAK_BLOCKS);
        activity.listen(GameActivityEvents.TICK, lobby::onTick);
        activity.listen(GameActivityEvents.REQUEST_START, lobby::requestStart);
        activity.listen(GamePlayerEvents.OFFER, lobby::offerPlayer);
        activity.listen(GamePlayerEvents.ADD, lobby::onAddPlayer);
        activity.listen(GamePlayerEvents.REMOVE, lobby::onRemovePlayer);
        activity.listen(GamePlayerEvents.JOIN_MESSAGE, lobby::onJoinMessage);
        activity.listen(GamePlayerEvents.LEAVE_MESSAGE, lobby::onLeaveMessage);
        activity.listen(GameWaitingLobbyEvents.BUILD_UI_LAYOUT, lobby::onBuildUiLayout);
        activity.listen(GameActivityEvents.STATE_UPDATE, lobby::updateState);
        lobby.setSidebarLines(((GameConfig)sourceConfig.comp_349()).description());
        class_5250 title = GameConfig.shortName(sourceConfig).method_27661();
        if (title.method_10866().method_10973() == null) {
            title.method_10862(title.method_10866().method_10977(class_124.field_1065));
        }
        if (title.method_10866().toString().contains("bold=null")) {
            title.method_10862(title.method_10866());
        }
        lobby.sidebar.setTitle((class_2561)title);
        lobby.updateSidebar();
        lobby.sidebar.show();
        return lobby;
    }

    @Nullable
    private class_2561 onJoinMessage(class_3222 player, class_2561 currentText, class_2561 defaultText) {
        boolean canStart;
        if (currentText == null || this.playerConfig.thresholdPlayers() == 1 && this.playerConfig.minPlayers() == 1 || this.playerConfig.playerConfig().maxPlayers().isEmpty() || this.gameSpace.getPlayers().spectators().contains(player)) {
            return currentText;
        }
        int count = this.gameSpace.getPlayers().participants().size();
        boolean bl = canStart = count >= this.playerConfig.minPlayers() && (this.isActiveFull(this.gameSpace.getPlayers().size()) || this.isReady(count));
        if (canStart) {
            return currentText;
        }
        int required = Math.max(Math.min(this.playerConfig.thresholdPlayers(), this.gameSpace.getServer().method_3788()), this.playerConfig.minPlayers()) - count;
        return class_2561.method_43473().method_10852(currentText).method_27693(" ").method_10852((class_2561)class_2561.method_43469((String)"text.plasmid.game.waiting_lobby.players_needed_to_start", (Object[])new Object[]{required}).method_27692(class_124.field_1054));
    }

    @Nullable
    private class_2561 onLeaveMessage(class_3222 player, class_2561 currentText, class_2561 defaultText) {
        boolean canStart;
        if (currentText == null || this.playerConfig.thresholdPlayers() == 1 && this.playerConfig.minPlayers() == 1 || this.playerConfig.playerConfig().maxPlayers().isEmpty() || this.gameSpace.getPlayers().spectators().contains(player)) {
            return currentText;
        }
        int count = this.gameSpace.getPlayers().participants().size() - 1;
        boolean bl = canStart = count >= this.playerConfig.minPlayers() && (this.isActiveFull(this.gameSpace.getPlayers().size() - 1) || this.isReady(count));
        if (canStart) {
            return currentText;
        }
        int required = Math.max(Math.min(this.playerConfig.thresholdPlayers(), this.gameSpace.getServer().method_3788()), this.playerConfig.minPlayers()) - count;
        return class_2561.method_43473().method_10852(currentText).method_27693(" ").method_10852((class_2561)class_2561.method_43469((String)"text.plasmid.game.waiting_lobby.players_needed_to_start", (Object[])new Object[]{required}).method_27692(class_124.field_1054));
    }

    private GameSpaceState.Builder updateState(GameSpaceState.Builder builder) {
        return builder.state(this.getTargetCountdownDuration() != -1L ? GameSpaceState.State.STARTING : GameSpaceState.State.WAITING);
    }

    public void setSidebarTitle(class_2561 text) {
        this.sidebar.setTitle(text);
    }

    public void setSidebarLines(List<class_2561> texts) {
        this.sidebarText = new ArrayList<class_2561>(texts.size());
        for (class_2561 line : texts) {
            class_5250 text = line.method_27661();
            if (line.method_10866().method_10973() == null) {
                text.method_10862(line.method_10866().method_10977(class_124.field_1054));
            }
            this.sidebarText.add((class_2561)text);
        }
    }

    private void onTick() {
        if (this.started) {
            return;
        }
        long time = this.gameSpace.getTime();
        if (time % 20L == 0L) {
            this.updateCountdown();
            this.tickCountdownBar();
            this.updateSidebar();
            this.tickCountdownSound();
        }
        if (this.countdownStart != -1L && time >= this.countdownStart + this.countdownDuration) {
            this.started = true;
            GameResult startResult = this.gameSpace.requestStart();
            if (startResult.isError()) {
                class_5250 message = class_2561.method_43471((String)"text.plasmid.game.waiting_lobby.bar.cancel").method_10852(startResult.error());
                this.gameSpace.getPlayers().sendMessage((class_2561)message.method_27692(class_124.field_1061));
                this.started = false;
                this.startRequested = false;
                this.countdownStart = -1L;
            } else {
                for (class_3222 player : this.gameSpace.getPlayers()) {
                    GuiInterface gui = GuiHelpers.getCurrentGui((class_3222)player);
                    if (!(gui instanceof WaitingLobbyUi)) continue;
                    player.method_14247();
                    PolymerUtils.reloadInventory((class_3222)player);
                }
            }
        }
    }

    @Nullable
    private GameResult requestStart() {
        if (this.gameSpace.getPlayers().participants().size() < this.playerConfig.minPlayers()) {
            return GameResult.error((class_2561)GameTexts.Start.notEnoughPlayers());
        }
        if (!this.started) {
            this.startRequested = true;
            return GameResult.ok();
        }
        return null;
    }

    private JoinOfferResult offerPlayer(JoinOffer offer) {
        this.updateCountdown();
        return offer.pass();
    }

    private void onAddPlayer(class_3222 player) {
        WaitingLobbyUi ui = new WaitingLobbyUi(player, this.gameSpace);
        ui.open();
    }

    private void onRemovePlayer(class_3222 player) {
        this.updateCountdown();
    }

    private void onBuildUiLayout(WaitingLobbyUiLayout layout, class_3222 player) {
        layout.addTrailing(new LeaveGameWaitingLobbyUiElement(this.gameSpace, player));
    }

    private void updateCountdown() {
        long targetDuration = this.getTargetCountdownDuration();
        if (targetDuration != this.countdownDuration) {
            this.updateCountdown(targetDuration);
        }
    }

    private void updateCountdown(long targetDuration) {
        if (targetDuration != -1L) {
            long time;
            long startTime = time = this.gameSpace.getTime();
            if (this.countdownStart != -1L) {
                long countdownEnd = this.countdownStart + this.countdownDuration;
                long timeRemaining = countdownEnd - time;
                long remainingDuration = Math.min(timeRemaining, targetDuration);
                startTime = Math.min(time, time + remainingDuration - targetDuration);
            }
            this.countdownStart = startTime;
            this.countdownDuration = targetDuration;
        } else {
            this.countdownStart = -1L;
            this.countdownDuration = -1L;
        }
    }

    private long getTargetCountdownDuration() {
        WaitingLobbyConfig.Countdown countdown = this.playerConfig.countdown();
        if (this.startRequested) {
            return 60L;
        }
        if (this.gameSpace.getPlayers().participants().size() >= this.playerConfig.minPlayers()) {
            if (this.isActiveFull(this.gameSpace.getPlayers().size())) {
                return (long)countdown.fullSeconds() * 20L;
            }
            if (this.isReady(this.gameSpace.getPlayers().participants().size())) {
                return (long)countdown.readySeconds() * 20L;
            }
        }
        return -1L;
    }

    private void tickCountdownBar() {
        if (this.countdownStart != -1L) {
            long time = this.gameSpace.getTime();
            long remainingTicks = this.getRemainingTicks(time);
            long remainingSeconds = remainingTicks / 20L;
            this.bar.setTitle((class_2561)class_2561.method_43469((String)"text.plasmid.game.waiting_lobby.bar.countdown", (Object[])new Object[]{remainingSeconds}));
            this.bar.setStyle(COUNTING_COLOR, BOSS_BAR_STYLE);
            this.bar.setProgress((float)remainingTicks / (float)this.countdownDuration);
        } else {
            this.bar.setTitle(WAITING_TITLE);
            this.bar.setStyle(WAITING_COLOR, BOSS_BAR_STYLE);
            this.bar.setProgress(1.0f);
        }
    }

    private void updateSidebar() {
        this.sidebar.set(b -> {
            b.add(PADDING_LINE);
            if (this.countdownStart != -1L) {
                long time = this.gameSpace.getTime();
                long remainingTicks = this.getRemainingTicks(time);
                long remainingSeconds = remainingTicks / 20L;
                b.add((class_2561)class_2561.method_43469((String)"text.plasmid.game.waiting_lobby.bar.countdown", (Object[])new Object[]{remainingSeconds}));
            } else {
                b.add(WAITING_TITLE);
            }
            b.add(class_5244.field_39003);
            if (this.playerConfig.playerConfig().maxPlayers().isEmpty()) {
                b.add((class_2561)class_2561.method_43469((String)"text.plasmid.game.waiting_lobby.sidebar.players", (Object[])new Object[]{class_2561.method_43470((String)("" + this.gameSpace.getPlayers().participants().size())).method_27692(class_124.field_1075), "", ""}));
            } else {
                b.add((class_2561)class_2561.method_43469((String)"text.plasmid.game.waiting_lobby.sidebar.players", (Object[])new Object[]{class_2561.method_43470((String)("" + this.gameSpace.getPlayers().participants().size())).method_27692(class_124.field_1075), class_2561.method_43470((String)"/").method_27692(class_124.field_1080), class_2561.method_43470((String)("" + this.playerConfig.playerConfig().maxPlayers().orElse(0))).method_27692(class_124.field_1075)}));
            }
            if (this.sidebarText != null && !this.sidebarText.isEmpty()) {
                b.add(class_5244.field_39003);
                for (class_2561 text : this.sidebarText) {
                    b.add(text);
                }
            }
            b.add(class_5244.field_39003);
        });
    }

    private void tickCountdownSound() {
        long time;
        long remainingSeconds;
        if (this.countdownStart != -1L && (remainingSeconds = this.getRemainingTicks(time = this.gameSpace.getTime()) / 20L) <= 3L) {
            GameSpacePlayers players = this.gameSpace.getPlayers();
            float pitch = remainingSeconds == 0L ? 1.5f : 1.0f;
            players.playSound(class_3417.field_14627, class_3419.field_15248, 1.0f, pitch);
        }
    }

    private long getRemainingTicks(long time) {
        return Math.max(this.countdownStart + this.countdownDuration - time, 0L);
    }

    private boolean isReady(int count) {
        return count >= this.playerConfig.thresholdPlayers();
    }

    private boolean isFull() {
        return this.limiter.isFull();
    }

    private boolean isActiveFull(int count) {
        if (this.isFull()) {
            return true;
        }
        MinecraftServer server = this.gameSpace.getServer();
        if (count >= server.method_3788()) {
            return true;
        }
        for (class_3218 world : server.method_3738()) {
            if (!GameWaitingLobby.hasActivePlayer(world) || GameSpaceManagerImpl.get().hasGame((class_1937)world)) continue;
            return false;
        }
        return true;
    }

    private static boolean hasActivePlayer(class_3218 world) {
        for (class_3222 player : world.method_18456()) {
            if (!AfkDisplayCompatibility.isActive(player)) continue;
            return true;
        }
        return false;
    }
}

