/*
 * Decompiled with CFR 0.152.
 */
package xyz.nucleoid.plasmid.api.game.common;

import net.minecraft.class_2561;
import xyz.nucleoid.plasmid.api.game.GameActivity;
import xyz.nucleoid.plasmid.api.game.GameSpace;
import xyz.nucleoid.plasmid.api.game.GameSpaceState;
import xyz.nucleoid.plasmid.api.game.GameTexts;
import xyz.nucleoid.plasmid.api.game.common.config.PlayerLimiterConfig;
import xyz.nucleoid.plasmid.api.game.event.GameActivityEvents;
import xyz.nucleoid.plasmid.api.game.event.GamePlayerEvents;
import xyz.nucleoid.plasmid.api.game.player.JoinIntent;
import xyz.nucleoid.plasmid.api.game.player.JoinOffer;
import xyz.nucleoid.plasmid.api.game.player.JoinOfferResult;

public final class PlayerLimiter {
    private final GameSpace gameSpace;
    private final PlayerLimiterConfig config;

    private PlayerLimiter(GameSpace gameSpace, PlayerLimiterConfig config) {
        this.gameSpace = gameSpace;
        this.config = config;
    }

    public static PlayerLimiter addTo(GameActivity activity, PlayerLimiterConfig config) {
        PlayerLimiter limiter = new PlayerLimiter(activity.getGameSpace(), config);
        activity.listen(GameActivityEvents.STATE_UPDATE, limiter::updateState);
        activity.listen(GamePlayerEvents.OFFER, limiter::offerPlayer);
        return limiter;
    }

    public boolean isFull() {
        int max = this.config.maxPlayers().orElse(-1);
        if (max < 0) {
            return false;
        }
        return this.gameSpace.getPlayers().participants().size() >= max;
    }

    private GameSpaceState.Builder updateState(GameSpaceState.Builder builder) {
        int max = this.config.maxPlayers().orElse(-1);
        return builder.maxPlayers(max).canPlay(max < 0 || this.gameSpace.getPlayers().participants().size() < max).canSpectate(this.config.allowSpectators());
    }

    private JoinOfferResult offerPlayer(JoinOffer offer) {
        if (offer.intent() == JoinIntent.SPECTATE) {
            return this.config.allowSpectators() ? offer.pass() : offer.reject((class_2561)GameTexts.Join.notAllowed());
        }
        int max = this.config.maxPlayers().orElse(-1);
        if (max < 0) {
            return offer.pass();
        }
        int newPlayerCount = this.gameSpace.getPlayers().participants().size() + offer.players().size();
        if (newPlayerCount > max) {
            return offer.reject((class_2561)GameTexts.Join.gameFull());
        }
        return offer.pass();
    }
}

