/*
 * Decompiled with CFR 0.152.
 */
package xyz.nucleoid.plasmid.api.game.common.team;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_124;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_268;
import net.minecraft.class_270;
import net.minecraft.class_5244;
import net.minecraft.class_5251;
import net.minecraft.class_9283;
import xyz.nucleoid.codecs.MoreCodecs;
import xyz.nucleoid.plasmid.api.util.ItemStackBuilder;
import xyz.nucleoid.plasmid.api.util.PlasmidCodecs;

public record GameTeamConfig(class_2561 name, Colors colors, boolean friendlyFire, class_270.class_271 collision, class_270.class_272 nameTagVisibility, class_2561 prefix, class_2561 suffix) {
    private static final Codec<class_270.class_271> COLLISION_CODEC = MoreCodecs.stringVariants((Object[])class_270.class_271.values(), rule -> rule.field_1436);
    private static final Codec<class_270.class_272> VISIBILITY_CODEC = MoreCodecs.stringVariants((Object[])class_270.class_272.values(), rule -> rule.field_1445);
    public static final MapCodec<GameTeamConfig> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)PlasmidCodecs.TEXT.optionalFieldOf("name").forGetter(config -> Optional.of(config.name)), (App)Colors.CODEC.optionalFieldOf("color", (Object)Colors.NONE).forGetter(GameTeamConfig::colors), (App)Codec.BOOL.optionalFieldOf("friendly_fire", (Object)true).forGetter(GameTeamConfig::friendlyFire), (App)COLLISION_CODEC.optionalFieldOf("collision", (Object)class_270.class_271.field_1437).forGetter(GameTeamConfig::collision), (App)VISIBILITY_CODEC.optionalFieldOf("name_tag_visibility", (Object)class_270.class_272.field_1442).forGetter(GameTeamConfig::nameTagVisibility), (App)PlasmidCodecs.TEXT.optionalFieldOf("prefix", (Object)class_5244.field_39003).forGetter(GameTeamConfig::prefix), (App)PlasmidCodecs.TEXT.optionalFieldOf("suffix", (Object)class_5244.field_39003).forGetter(GameTeamConfig::suffix)).apply((Applicative)instance, GameTeamConfig::of));
    public static final Codec<GameTeamConfig> CODEC = MAP_CODEC.codec();
    public static final GameTeamConfig DEFAULT = GameTeamConfig.builder().build();

    public GameTeamConfig(class_2561 name, Colors colors, boolean friendlyFire, class_270.class_271 collision, class_270.class_272 nameTagVisibility, class_2561 prefix, class_2561 suffix) {
        this.name = name.method_27661().method_27694(style -> style.method_10973() == null ? style.method_10977(colors.chatFormatting()) : style);
        this.colors = colors;
        this.friendlyFire = friendlyFire;
        this.collision = collision;
        this.nameTagVisibility = nameTagVisibility;
        this.prefix = prefix;
        this.suffix = suffix;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(GameTeamConfig config) {
        return new Builder(config);
    }

    public class_1799 createFirework(int flight, class_9283.class_1782 type) {
        int color = this.fireworkColor().method_27716();
        return ItemStackBuilder.firework(color, flight, type).build();
    }

    public class_1799 applyDye(class_1799 stack) {
        return ItemStackBuilder.of(stack).setDyeColor(this.dyeColor().method_27716()).build();
    }

    public class_124 chatFormatting() {
        return this.colors.chatFormatting();
    }

    public class_5251 fireworkColor() {
        return this.colors.fireworkColor();
    }

    public class_1767 blockDyeColor() {
        return this.colors.blockDyeColor();
    }

    public class_5251 dyeColor() {
        return this.colors.dyeColor();
    }

    public void applyToScoreboard(class_268 scoreboardTeam) {
        scoreboardTeam.method_1137(this.name());
        scoreboardTeam.method_1141(this.chatFormatting());
        scoreboardTeam.method_1135(this.friendlyFire());
        scoreboardTeam.method_1145(this.collision());
        scoreboardTeam.method_1149(this.nameTagVisibility());
        scoreboardTeam.method_1138(this.prefix());
        scoreboardTeam.method_1139(this.suffix());
    }

    public static GameTeamConfig of(Optional<class_2561> name, Colors colors, boolean friendlyFire, class_270.class_271 collision, class_270.class_272 nameTagVisibility, class_2561 prefix, class_2561 suffix) {
        return new GameTeamConfig(GameTeamConfig.getNameWithColorFallback(name, colors), colors, friendlyFire, collision, nameTagVisibility, prefix, suffix);
    }

    private static class_2561 getNameWithColorFallback(Optional<class_2561> name, Colors colors) {
        return name.orElseGet(() -> {
            if (colors == Colors.NONE) {
                return class_2561.method_43470((String)"Team");
            }
            return class_2561.method_43471((String)("color.minecraft." + colors.blockDyeColor().method_7792()));
        });
    }

    public record Colors(class_124 chatFormatting, class_5251 dyeColor, class_1767 blockDyeColor, class_5251 fireworkColor) {
        private static final Codec<Colors> RECORD_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_124.field_39218.optionalFieldOf("chat", (Object)class_124.field_1070).forGetter(Colors::chatFormatting), (App)class_5251.field_39242.fieldOf("dye").forGetter(Colors::dyeColor), (App)class_1767.field_41600.fieldOf("block_dye").forGetter(Colors::blockDyeColor), (App)class_5251.field_39242.fieldOf("firework").forGetter(Colors::fireworkColor)).apply((Applicative)instance, Colors::new));
        public static final Codec<Colors> CODEC = Codec.either((Codec)class_1767.field_41600, RECORD_CODEC).xmap(either -> (Colors)either.map(Colors::from, Function.identity()), Either::right);
        public static final Colors NONE = new Colors(class_124.field_1070, class_5251.method_27718((class_124)class_124.field_1068), class_1767.field_7952, class_5251.method_27718((class_124)class_124.field_1068));

        public static Colors from(class_1767 dyeColor) {
            class_124 formatting = Colors.formatByDye(dyeColor);
            return new Colors(formatting, class_5251.method_27717((int)dyeColor.method_7787()), dyeColor, class_5251.method_27717((int)dyeColor.method_7790()));
        }

        private static class_124 formatByDye(class_1767 dye) {
            return switch (dye) {
                default -> throw new MatchException(null, null);
                case class_1767.field_7952 -> class_124.field_1068;
                case class_1767.field_7946 -> class_124.field_1065;
                case class_1767.field_7958, class_1767.field_7954 -> class_124.field_1076;
                case class_1767.field_7951 -> class_124.field_1075;
                case class_1767.field_7947 -> class_124.field_1054;
                case class_1767.field_7961 -> class_124.field_1060;
                case class_1767.field_7944 -> class_124.field_1063;
                case class_1767.field_7967 -> class_124.field_1080;
                case class_1767.field_7955 -> class_124.field_1062;
                case class_1767.field_7945 -> class_124.field_1064;
                case class_1767.field_7966 -> class_124.field_1078;
                case class_1767.field_7957 -> class_124.field_1079;
                case class_1767.field_7942 -> class_124.field_1077;
                case class_1767.field_7964 -> class_124.field_1061;
                case class_1767.field_7963 -> class_124.field_1074;
            };
        }
    }

    public static final class Builder {
        private Optional<class_2561> name = Optional.empty();
        private Colors colors = Colors.NONE;
        private boolean friendlyFire = true;
        private class_270.class_271 collision = class_270.class_271.field_1437;
        private class_270.class_272 nameTagVisibility = class_270.class_272.field_1442;
        private class_2561 prefix = class_5244.field_39003;
        private class_2561 suffix = class_5244.field_39003;

        Builder() {
        }

        Builder(GameTeamConfig config) {
            this.name = Optional.of(config.name);
            this.colors = config.colors;
            this.friendlyFire = config.friendlyFire;
            this.collision = config.collision;
            this.nameTagVisibility = config.nameTagVisibility;
            this.prefix = config.prefix;
            this.suffix = config.suffix;
        }

        public Builder setName(class_2561 name) {
            this.name = Optional.of(name);
            return this;
        }

        public Builder setColors(Colors colors) {
            this.colors = colors;
            return this;
        }

        public Builder setFriendlyFire(boolean friendlyFire) {
            this.friendlyFire = friendlyFire;
            return this;
        }

        public Builder setCollision(class_270.class_271 collision) {
            this.collision = collision;
            return this;
        }

        public Builder setNameTagVisibility(class_270.class_272 nameTagVisibility) {
            this.nameTagVisibility = nameTagVisibility;
            return this;
        }

        public Builder setPrefix(class_2561 prefix) {
            this.prefix = prefix;
            return this;
        }

        public Builder setSuffix(class_2561 suffix) {
            this.suffix = suffix;
            return this;
        }

        public GameTeamConfig build() {
            return GameTeamConfig.of(this.name, this.colors, this.friendlyFire, this.collision, this.nameTagVisibility, this.prefix, this.suffix);
        }
    }
}

