/*
 * Decompiled with CFR 0.152.
 */
package xyz.nucleoid.plasmid.api.game.common.team;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2596;
import net.minecraft.class_268;
import net.minecraft.class_269;
import net.minecraft.class_2703;
import net.minecraft.class_3222;
import net.minecraft.class_5900;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.plasmid.api.game.GameActivity;
import xyz.nucleoid.plasmid.api.game.GameSpace;
import xyz.nucleoid.plasmid.api.game.common.team.GameTeam;
import xyz.nucleoid.plasmid.api.game.common.team.GameTeamConfig;
import xyz.nucleoid.plasmid.api.game.common.team.GameTeamKey;
import xyz.nucleoid.plasmid.api.game.common.team.GameTeamList;
import xyz.nucleoid.plasmid.api.game.event.GamePlayerEvents;
import xyz.nucleoid.plasmid.api.game.player.MutablePlayerSet;
import xyz.nucleoid.plasmid.api.game.player.PlayerSet;
import xyz.nucleoid.plasmid.api.util.PlayerRef;
import xyz.nucleoid.plasmid.mixin.chat.PlayerListS2CPacketEntryAccessor;
import xyz.nucleoid.stimuli.event.EventResult;
import xyz.nucleoid.stimuli.event.player.PlayerDamageEvent;

public final class TeamManager
implements Iterable<GameTeam> {
    private final Map<GameTeamKey, State> teamToState = new Object2ObjectLinkedOpenHashMap();
    private final Map<UUID, GameTeamKey> playerToTeam = new Object2ObjectOpenHashMap();
    private final class_269 scoreboard = new class_269();
    private final GameSpace gameSpace;
    private boolean applyNameFormatting = true;

    private TeamManager(GameSpace gameSpace) {
        this.gameSpace = gameSpace;
    }

    public static TeamManager addTo(GameActivity activity) {
        TeamManager manager = new TeamManager(activity.getGameSpace());
        activity.listen(GamePlayerEvents.ADD, manager::onAddPlayer);
        activity.listen(GamePlayerEvents.REMOVE, manager::onRemovePlayer);
        activity.listen(PlayerDamageEvent.EVENT, manager::onDamagePlayer);
        activity.listen(GamePlayerEvents.DISPLAY_NAME, manager::onFormatDisplayName);
        return manager;
    }

    public boolean addTeam(GameTeamKey key, GameTeamConfig config) {
        return this.addTeam(new GameTeam(key, config));
    }

    public boolean addTeam(GameTeam team) {
        return this.teamToState.putIfAbsent(team.key(), new State(this, team)) == null;
    }

    public void addTeams(GameTeamList teams) {
        teams.forEach(this::addTeam);
    }

    public void setTeamConfig(GameTeamKey team, GameTeamConfig config) {
        this.teamState(team).setConfig(config);
        this.sendTeamUpdates(team);
    }

    public GameTeamConfig getTeamConfig(GameTeamKey team) {
        return this.teamState((GameTeamKey)team).team.config();
    }

    public boolean addPlayerTo(PlayerRef player, GameTeamKey team) {
        GameTeamKey lastTeam = this.playerToTeam.get(player.id());
        if (lastTeam == team) {
            return false;
        }
        if (lastTeam != null) {
            this.removePlayerFrom(player, lastTeam);
        }
        this.playerToTeam.put(player.id(), team);
        for (class_3222 gameSpacePlayer : this.gameSpace.getPlayers()) {
            this.sendTeamsToPlayer(gameSpacePlayer);
        }
        State state = this.teamState(team);
        if (state.allPlayers.add(player)) {
            class_3222 entity = this.gameSpace.getPlayers().getEntity(player.id());
            if (entity != null) {
                this.addOnlinePlayer(entity, state);
            }
            return true;
        }
        return false;
    }

    public boolean addPlayerTo(class_3222 player, GameTeamKey team) {
        return this.addPlayerTo(PlayerRef.of((class_1657)player), team);
    }

    public boolean removePlayerFrom(class_3222 player, GameTeamKey team) {
        return this.removePlayerFrom(PlayerRef.of((class_1657)player), team);
    }

    public boolean removePlayerFrom(PlayerRef player, GameTeamKey team) {
        if (!this.playerToTeam.remove(player.id(), team)) {
            return false;
        }
        State state = this.teamState(team);
        if (!state.allPlayers.remove(player)) {
            throw new IllegalStateException("Player " + String.valueOf(player) + " was not in team " + String.valueOf(team) + ", but had a mapping");
        }
        class_3222 entity = state.onlinePlayers.getEntity(player.id());
        if (entity != null) {
            this.sendRemoveTeamsForPlayer(entity);
            this.removeOnlinePlayer(entity, state);
        }
        return true;
    }

    @Nullable
    public GameTeamKey removePlayer(class_3222 player) {
        return this.removePlayer(PlayerRef.of((class_1657)player));
    }

    @Nullable
    public GameTeamKey removePlayer(PlayerRef player) {
        GameTeamKey team = this.teamFor(player);
        if (team != null) {
            this.removePlayerFrom(player, team);
        }
        return team;
    }

    @Nullable
    public GameTeamKey teamFor(PlayerRef player) {
        return this.playerToTeam.get(player.id());
    }

    @Nullable
    public GameTeamKey teamFor(class_3222 player) {
        return this.playerToTeam.get(player.method_5667());
    }

    public PlayerSet playersIn(GameTeamKey team) {
        return this.teamState((GameTeamKey)team).onlinePlayers;
    }

    public Set<PlayerRef> allPlayersIn(GameTeamKey team) {
        return this.teamState((GameTeamKey)team).allPlayers;
    }

    private class_2561 formatPlayerName(class_3222 player, class_2561 name) {
        GameTeamKey team = this.teamFor(player);
        if (team != null) {
            GameTeamConfig config = this.teamState((GameTeamKey)team).team.config();
            class_2583 style = class_2583.field_24360.method_27706(config.chatFormatting());
            return class_2561.method_43473().method_10852(config.prefix()).method_10852((class_2561)name.method_27661().method_10862(style)).method_10852(config.suffix());
        }
        return name;
    }

    @Nullable
    public GameTeamKey getSmallestTeam() {
        GameTeamKey smallest = null;
        int count = Integer.MAX_VALUE;
        for (State state : this.teamToState.values()) {
            int size = state.onlinePlayers.size();
            if (size > count) continue;
            smallest = state.team.key();
            count = size;
        }
        return smallest;
    }

    public void enableNameFormatting() {
        this.applyNameFormatting = true;
    }

    public void disableNameFormatting() {
        this.applyNameFormatting = false;
    }

    @NotNull
    private State teamState(GameTeamKey team) {
        return (State)Preconditions.checkNotNull((Object)this.teamToState.get(team), (Object)("unregistered team for " + String.valueOf(team)));
    }

    private void onAddPlayer(class_3222 player) {
        this.sendTeamsToPlayer(player);
        this.restoreFormerTeams(player);
    }

    private void restoreFormerTeams(class_3222 player) {
        GameTeamKey team = this.teamFor(player);
        if (team != null) {
            State state = this.teamState(team);
            this.addOnlinePlayer(player, state);
        }
    }

    private void onRemovePlayer(class_3222 player) {
        GameTeamKey team = this.teamFor(player);
        if (team != null) {
            State state = this.teamState(team);
            this.removeOnlinePlayer(player, state);
        }
        if (!player.method_14239()) {
            this.sendRemoveTeamsForPlayer(player);
        }
    }

    private EventResult onDamagePlayer(class_3222 player, class_1282 source, float amount) {
        class_1297 class_12972 = source.method_5529();
        if (class_12972 instanceof class_3222) {
            class_3222 attacker = (class_3222)class_12972;
            GameTeamKey playerTeam = this.teamFor(player);
            GameTeamKey attackerTeam = this.teamFor(attacker);
            if (playerTeam != null && playerTeam == attackerTeam && !this.getTeamConfig(playerTeam).friendlyFire()) {
                return EventResult.DENY;
            }
        }
        return EventResult.PASS;
    }

    private class_2561 onFormatDisplayName(class_3222 player, class_2561 name, class_2561 vanilla) {
        return this.applyNameFormatting ? this.formatPlayerName(player, name) : name;
    }

    private void sendTeamsToPlayer(class_3222 player) {
        for (State state : this.teamToState.values()) {
            player.field_13987.method_14364((class_2596)class_5900.method_34172((class_268)state.scoreboardTeam, (boolean)true));
            for (class_3222 member : state.onlinePlayers) {
                player.field_13987.method_14364((class_2596)this.updatePlayerName(member));
            }
        }
    }

    private void sendRemoveTeamsForPlayer(class_3222 player) {
        for (State state : this.teamToState.values()) {
            player.field_13987.method_14364((class_2596)class_5900.method_34170((class_268)state.scoreboardTeam));
            for (class_3222 member : state.onlinePlayers) {
                player.field_13987.method_14364((class_2596)this.resetPlayerName(member));
            }
        }
    }

    private void addOnlinePlayer(class_3222 player, State state) {
        if (!state.allPlayers.contains(PlayerRef.of((class_1657)player))) {
            throw new IllegalStateException("Tried to mark player " + player.method_5820() + " as online in team " + String.valueOf(state.team) + ", but they are not in this team");
        }
        state.onlinePlayers.add(player);
        state.scoreboardTeam.method_1204().add(player.method_5820());
        this.sendPacketToAll((class_2596<?>)this.changePlayerTeam(player, state, class_5900.class_5901.field_29155));
        this.sendPacketToAll((class_2596<?>)this.resetPlayerName(player));
    }

    private void removeOnlinePlayer(class_3222 player, State state) {
        if (!state.onlinePlayers.remove(player)) {
            throw new IllegalStateException("Tried to mark player " + player.method_5820() + " as offline in team " + String.valueOf(state.team) + ", but they were not online in this team");
        }
        state.scoreboardTeam.method_1204().remove(player.method_5820());
        this.sendPacketToAll((class_2596<?>)this.changePlayerTeam(player, state, class_5900.class_5901.field_29156));
        this.sendPacketToAll((class_2596<?>)this.resetPlayerName(player));
    }

    private void sendTeamUpdates(GameTeamKey gameTeamKey) {
        State state = this.teamState(gameTeamKey);
        this.sendPacketToAll((class_2596<?>)class_5900.method_34172((class_268)state.scoreboardTeam, (boolean)true));
    }

    private class_5900 changePlayerTeam(class_3222 player, State team, class_5900.class_5901 operation) {
        return class_5900.method_34171((class_268)team.scoreboardTeam, (String)player.method_7334().name(), (class_5900.class_5901)operation);
    }

    private class_2703 updatePlayerName(class_3222 player) {
        class_2703 packet = new class_2703(class_2703.class_5893.field_29139, player);
        class_2703.class_2705 entry = (class_2703.class_2705)packet.method_46329().get(0);
        class_2561 name = player.method_14206();
        if (name == null) {
            name = player.method_5477();
        }
        ((PlayerListS2CPacketEntryAccessor)entry).setDisplayName(this.formatPlayerName(player, name));
        return packet;
    }

    private class_2703 resetPlayerName(class_3222 player) {
        return new class_2703(class_2703.class_5893.field_29139, player);
    }

    private void sendPacketToAll(class_2596<?> packet) {
        this.gameSpace.getPlayers().sendPacket(packet);
    }

    @Override
    @NotNull
    public Iterator<GameTeam> iterator() {
        return Iterators.transform(this.teamToState.values().iterator(), state -> state.team);
    }

    final class State {
        final Set<PlayerRef> allPlayers = new ObjectOpenHashSet();
        final MutablePlayerSet onlinePlayers;
        final class_268 scoreboardTeam;
        GameTeam team;

        State(TeamManager this$0, GameTeam team) {
            this.onlinePlayers = new MutablePlayerSet(this$0.gameSpace.getServer());
            this.scoreboardTeam = new class_268(this$0.scoreboard, team.key().id());
            team.config().applyToScoreboard(this.scoreboardTeam);
            this.team = team;
        }

        public void setConfig(GameTeamConfig config) {
            this.team = this.team.withConfig(config);
            config.applyToScoreboard(this.scoreboardTeam);
        }
    }
}

