/*
 * Decompiled with CFR 0.152.
 */
package xyz.nucleoid.plasmid.api.game.common.team;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntMaps;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import xyz.nucleoid.plasmid.api.event.GameEvents;
import xyz.nucleoid.plasmid.api.game.GameActivity;
import xyz.nucleoid.plasmid.api.game.GameSpace;
import xyz.nucleoid.plasmid.api.game.common.team.GameTeam;
import xyz.nucleoid.plasmid.api.game.common.team.GameTeamConfig;
import xyz.nucleoid.plasmid.api.game.common.team.GameTeamKey;
import xyz.nucleoid.plasmid.api.game.common.team.GameTeamList;
import xyz.nucleoid.plasmid.api.game.common.team.TeamAllocator;
import xyz.nucleoid.plasmid.api.game.common.ui.WaitingLobbyUiLayout;
import xyz.nucleoid.plasmid.api.game.event.GameWaitingLobbyEvents;
import xyz.nucleoid.plasmid.api.game.event.TeamSelectionLobbyEvents;
import xyz.nucleoid.plasmid.api.game.player.PlayerIterable;
import xyz.nucleoid.plasmid.impl.game.common.ui.element.TeamSelectionWaitingLobbyUiElement;

public final class TeamSelectionLobby {
    private final GameSpace gameSpace;
    private final GameTeamList teams;
    private final Reference2IntMap<GameTeamKey> maxTeamSize = new Reference2IntOpenHashMap();
    private final Map<UUID, GameTeamKey> teamPreference = new Object2ObjectOpenHashMap();

    private TeamSelectionLobby(GameSpace gameSpace, GameTeamList teams) {
        this.gameSpace = gameSpace;
        this.teams = teams;
    }

    public static TeamSelectionLobby addTo(GameActivity activity, GameTeamList teams) {
        TeamSelectionLobby lobby = new TeamSelectionLobby(activity.getGameSpace(), teams);
        activity.listen(GameWaitingLobbyEvents.BUILD_UI_LAYOUT, lobby::onBuildUiLayout);
        return lobby;
    }

    public void setSizeForTeam(GameTeamKey team, int size) {
        this.maxTeamSize.put((Object)team, size);
    }

    private void onBuildUiLayout(WaitingLobbyUiLayout layout, class_3222 player) {
        if (!this.gameSpace.getPlayers().participants().contains(player)) {
            return;
        }
        layout.addLeading(new TeamSelectionWaitingLobbyUiElement(this.teams, key -> key == this.teamPreference.get(player.method_5667()), key -> {
            GameTeam team = this.teams.byKey((GameTeamKey)key);
            if (team != null) {
                GameTeamConfig config = team.config();
                this.teamPreference.put(player.method_5667(), (GameTeamKey)key);
                layout.refresh();
                class_5250 message = class_2561.method_43469((String)"text.plasmid.team_selection.requested_team", (Object[])new Object[]{class_2561.method_43469((String)"text.plasmid.team_selection.suffixed_team", (Object[])new Object[]{config.name()}).method_27692(config.chatFormatting())});
                player.method_7353((class_2561)message, false);
            }
        }));
    }

    public void allocate(PlayerIterable players, BiConsumer<GameTeamKey, class_3222> apply) {
        List teamKeys = this.teams.stream().map(GameTeam::key).collect(Collectors.toList());
        TeamAllocator<GameTeamKey, class_3222> allocator = new TeamAllocator<GameTeamKey, class_3222>(teamKeys);
        for (Reference2IntMap.Entry entry : Reference2IntMaps.fastIterable(this.maxTeamSize)) {
            allocator.setSizeForTeam((GameTeamKey)entry.getKey(), entry.getIntValue());
        }
        for (class_3222 player : players) {
            GameTeamKey preference = this.teamPreference.get(player.method_5667());
            allocator.add(player, preference);
        }
        this.gameSpace.getBehavior().invoker(TeamSelectionLobbyEvents.FINALIZE).onFinalizeTeamSelection(allocator, players);
        ((GameEvents.TeamSelectionLobbyFinalize)GameEvents.TEAM_SELECTION_LOBBY_FINALIZE.invoker()).onFinalizeTeamSelection(this.gameSpace, allocator, players);
        allocator.allocate(apply);
    }
}

