/*
 * Decompiled with CFR 0.152.
 */
package xyz.nucleoid.plasmid.api.game.config;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5381;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_6895;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.codecs.MoreCodecs;
import xyz.nucleoid.plasmid.api.game.GameOpenContext;
import xyz.nucleoid.plasmid.api.game.GameOpenProcedure;
import xyz.nucleoid.plasmid.api.game.GameType;
import xyz.nucleoid.plasmid.api.game.GameTypes;
import xyz.nucleoid.plasmid.api.game.config.CustomValuesConfig;
import xyz.nucleoid.plasmid.api.registry.PlasmidRegistries;
import xyz.nucleoid.plasmid.api.registry.PlasmidRegistryKeys;
import xyz.nucleoid.plasmid.api.util.PlasmidCodecs;
import xyz.nucleoid.plasmid.impl.PlasmidConfig;
import xyz.nucleoid.server.translations.api.language.ServerLanguage;
import xyz.nucleoid.server.translations.api.language.ServerLanguageDefinition;

public record GameConfig<C>(GameType<C> type, @Nullable class_2561 name, @Nullable class_2561 shortName, @Nullable List<class_2561> description, @Nullable class_1799 icon, CustomValuesConfig custom, C config) {
    @Nullable
    private final List<class_2561> description;
    @Nullable
    private final class_1799 icon;
    public static final Codec<GameConfig<?>> DIRECT_CODEC = PlasmidRegistries.GAME_TYPE.method_39673().dispatch(GameConfig::type, GameConfig::createTypedCodec);
    @Deprecated
    public static final Codec<GameConfig<?>> REGISTRY_CODEC = Codec.lazyInitialized(() -> {
        if (!PlasmidConfig.get().ignoreInvalidGames()) {
            return DIRECT_CODEC;
        }
        return Codec.withAlternative(DIRECT_CODEC, (Codec)Codec.unit(() -> new GameConfig<String>(GameTypes.INVALID, null, null, null, null, null, "")));
    });
    public static final Codec<class_6880<GameConfig<?>>> ENTRY_CODEC = class_5381.method_29749(PlasmidRegistryKeys.GAME_CONFIG, DIRECT_CODEC);
    public static final Codec<class_6885<GameConfig<?>>> ENTRY_LIST_CODEC = class_6895.method_40340(PlasmidRegistryKeys.GAME_CONFIG);
    @Deprecated
    public static final Codec<class_6880<GameConfig<?>>> CODEC = ENTRY_CODEC;

    public static GameOpenProcedure openProcedure(MinecraftServer server, class_6880<GameConfig<?>> config) {
        GameOpenContext context = new GameOpenContext(server, config);
        return ((GameConfig)config.comp_349()).type().open(context);
    }

    public static String sourceName(class_6880<GameConfig<?>> config) {
        return config.method_40230().map(e -> e.method_29177().toString()).orElse("[unknown source]");
    }

    public static class_2561 name(class_6880<GameConfig<?>> config) {
        class_2561 name = ((GameConfig)config.comp_349()).name;
        if (name != null) {
            return name;
        }
        Optional<String> translationKey = config.method_40230().map(key -> class_156.method_646((String)"game", (class_2960)key.method_29177())).filter(GameConfig::hasTranslationFor);
        if (translationKey.isPresent()) {
            return class_2561.method_43471((String)translationKey.get());
        }
        return ((GameConfig)config.comp_349()).type.name();
    }

    public static class_2561 shortName(class_6880<GameConfig<?>> config) {
        if (((GameConfig)config.comp_349()).shortName != null) {
            return ((GameConfig)config.comp_349()).shortName;
        }
        return GameConfig.name(config);
    }

    public List<class_2561> description() {
        if (this.description != null) {
            return this.description;
        }
        return Collections.emptyList();
    }

    public class_1799 icon() {
        if (this.icon != null) {
            return this.icon;
        }
        return class_1802.field_8270.method_7854();
    }

    private static boolean hasTranslationFor(String translationKey) {
        ServerLanguage language = ServerLanguage.getLanguage((ServerLanguageDefinition)ServerLanguageDefinition.DEFAULT);
        return language.serverTranslations().contains(translationKey);
    }

    private static <C> MapCodec<GameConfig<C>> createTypedCodec(GameType<C> type) {
        return RecordCodecBuilder.mapCodec(i -> i.group((App)type.configCodec().forGetter(GameConfig::config), (App)Metadata.MAP_CODEC.forGetter(Metadata::from)).apply((Applicative)i, (config, metadata) -> new GameConfig<Object>(type, metadata.name.orElse(null), metadata.shortName.orElse(null), metadata.description.orElse(null), metadata.icon, metadata.custom, config)));
    }

    @Deprecated(forRemoval=true)
    public GameOpenProcedure openProcedure(MinecraftServer server) {
        return GameConfig.openProcedure(server, class_6880.method_40223((Object)this));
    }

    private record Metadata(Optional<class_2561> name, Optional<class_2561> shortName, Optional<List<class_2561>> description, class_1799 icon, CustomValuesConfig custom) {
        static final MapCodec<Metadata> MAP_CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)PlasmidCodecs.TEXT.optionalFieldOf("name").forGetter(Metadata::name), (App)PlasmidCodecs.TEXT.optionalFieldOf("short_name").forGetter(Metadata::shortName), (App)MoreCodecs.listOrUnit(PlasmidCodecs.TEXT).optionalFieldOf("description").forGetter(Metadata::description), (App)MoreCodecs.ITEM_STACK.optionalFieldOf("icon", (Object)new class_1799((class_1935)class_1802.field_8270)).forGetter(Metadata::icon), (App)CustomValuesConfig.CODEC.fieldOf("custom").orElseGet(CustomValuesConfig::empty).forGetter(Metadata::custom)).apply((Applicative)i, Metadata::new));

        public static Metadata from(GameConfig<?> game) {
            return new Metadata(Optional.ofNullable(game.name), Optional.ofNullable(game.shortName), Optional.ofNullable(game.description), game.icon, game.custom);
        }
    }
}

