/*
 * Decompiled with CFR 0.152.
 */
package xyz.nucleoid.plasmid.api.game.event;

import com.google.common.base.Throwables;
import com.google.common.collect.Iterators;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.plasmid.api.game.event.GameEventExceptionHandler;
import xyz.nucleoid.stimuli.event.EventInvokerContext;
import xyz.nucleoid.stimuli.event.EventRegistrar;
import xyz.nucleoid.stimuli.event.StimulusEvent;

public final class GameEventListeners
implements EventRegistrar {
    private final GameEventExceptionHandler exceptionHandler;
    private final Reference2ObjectMap<StimulusEvent<?>, List<Object>> listeners = new Reference2ObjectOpenHashMap();
    private final Reference2ObjectMap<StimulusEvent<?>, InvokerEntry<?>> invokers = new Reference2ObjectOpenHashMap();

    public GameEventListeners(GameEventExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    public <T> void listen(StimulusEvent<T> event, T listener) {
        ((List)this.listeners.computeIfAbsent(event, e -> new ArrayList())).add(listener);
        this.updateInvoker(event);
    }

    public <T> void unlisten(StimulusEvent<T> event, T listener) {
        List listeners = (List)this.listeners.get(event);
        if (listeners != null && listeners.remove(listener)) {
            if (listeners.isEmpty()) {
                this.listeners.remove(event);
            }
            this.updateInvoker(event);
        }
    }

    private <T> void updateInvoker(StimulusEvent<T> event) {
        List listeners = (List)this.listeners.get(event);
        if (listeners != null && !listeners.isEmpty()) {
            InvokerEntry entry = (InvokerEntry)this.invokers.get(event);
            if (entry != null) {
                entry.listeners = listeners;
            } else {
                this.invokers.put(event, new InvokerEntry<T>(this, event, listeners));
            }
        } else {
            this.invokers.remove(event);
        }
    }

    @NotNull
    public <T> T getInvoker(StimulusEvent<T> event) {
        InvokerEntry<T> entry = this.getInvokerEntry(event);
        return (T)(entry != null ? entry.invoker : event.emptyInvoker());
    }

    @NotNull
    public <T> T getPropagatingInvoker(StimulusEvent<T> event) {
        InvokerEntry<T> entry = this.getInvokerEntry(event);
        return (T)(entry != null ? entry.propagatingInvoker : event.emptyInvoker());
    }

    @NotNull
    public <T> Iterable<T> getInvokers(StimulusEvent<T> event) {
        InvokerEntry<T> entry = this.getInvokerEntry(event);
        return entry != null ? entry : Collections.emptyList();
    }

    @Nullable
    public <T> Iterable<T> getInvokersOrNull(StimulusEvent<T> event) {
        return this.getInvokerEntry(event);
    }

    @Nullable
    private <T> InvokerEntry<T> getInvokerEntry(StimulusEvent<T> event) {
        return (InvokerEntry)this.invokers.get(event);
    }

    final class InvokerEntry<T>
    implements Iterable<T> {
        private final StimulusEvent<T> event;
        private List<T> listeners;
        private final T invoker;
        private final T propagatingInvoker;

        InvokerEntry(GameEventListeners this$0, StimulusEvent<T> event, List<T> listeners) {
            this.event = event;
            this.listeners = listeners;
            GameEventExceptionHandler exceptionHandler = this$0.exceptionHandler;
            this.invoker = this.createInvoker(throwable -> exceptionHandler.handleException(event, (Throwable)throwable));
            this.propagatingInvoker = this.createInvoker(throwable -> {
                exceptionHandler.handleException(event, (Throwable)throwable);
                Throwables.throwIfUnchecked((Throwable)throwable);
                throw new RuntimeException((Throwable)throwable);
            });
        }

        private T createInvoker(final Consumer<Throwable> exceptionHandler) {
            return (T)this.event.createInvoker(new EventInvokerContext<T>(){

                public Iterable<T> getListeners() {
                    return InvokerEntry.this.listeners;
                }

                public void handleException(Throwable throwable) {
                    exceptionHandler.accept(throwable);
                }
            });
        }

        @Override
        @NotNull
        public Iterator<T> iterator() {
            return Iterators.singletonIterator(this.invoker);
        }
    }
}

