/*
 * Decompiled with CFR 0.152.
 */
package xyz.nucleoid.plasmid.api.game.rule;

import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.plasmid.api.game.rule.GameRuleType;
import xyz.nucleoid.stimuli.event.EventListenerMap;
import xyz.nucleoid.stimuli.event.EventRegistrar;
import xyz.nucleoid.stimuli.event.EventResult;
import xyz.nucleoid.stimuli.event.StimulusEvent;

public final class GameRuleMap {
    private final Reference2ObjectMap<GameRuleType, EventResult> rules = new Reference2ObjectOpenHashMap();
    private EventListenerMap listeners = null;

    public static GameRuleMap empty() {
        return new GameRuleMap();
    }

    public void set(GameRuleType rule, EventResult result) {
        if (this.trySet(rule, result)) {
            this.listeners = null;
        }
    }

    @NotNull
    public EventResult test(GameRuleType rule) {
        return (EventResult)this.rules.getOrDefault((Object)rule, (Object)EventResult.PASS);
    }

    @Nullable
    public <T> Iterable<T> getInvokersOrNull(StimulusEvent<T> event) {
        Collection listeners = this.getListeners().get(event);
        return !listeners.isEmpty() ? listeners : null;
    }

    private boolean trySet(GameRuleType rule, EventResult result) {
        if (result != EventResult.PASS) {
            return this.rules.put((Object)rule, (Object)result) != result;
        }
        return this.rules.remove((Object)rule) != null;
    }

    private EventListenerMap getListeners() {
        EventListenerMap listeners = this.listeners;
        if (listeners == null) {
            this.listeners = listeners = this.buildListeners();
        }
        return listeners;
    }

    private EventListenerMap buildListeners() {
        EventListenerMap listeners = new EventListenerMap();
        this.rules.entrySet().stream().sorted(Map.Entry.comparingByKey(GameRuleType.COMPARATOR)).forEach(entry -> {
            GameRuleType rule = (GameRuleType)entry.getKey();
            EventResult result = (EventResult)entry.getValue();
            rule.enforce((EventRegistrar)listeners, result);
        });
        return listeners;
    }
}

